% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_messages.R
\name{bartlett_message}
\alias{bartlett_message}
\title{Display homogeneity of variance test as a message}
\usage{
bartlett_message(data, x, y, lab = NULL, k = 2, output = "message",
  ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{lab}{A character describing label for the variable. If \code{NULL}, variable
name will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{output}{What output is desired: \code{"message"} (default) or \code{"stats"} (or
\code{"tidy"}) objects.}

\item{...}{Additional arguments (ignored).}
}
\value{
A list of class \code{"htest"} containing the following components:
  \item{statistic}{Bartlett's K-squared test statistic.}
  \item{parameter}{the degrees of freedom of the approximate chi-squared
    distribution of the test statistic.}
  \item{p.value}{the p-value of the test.}
  \item{method}{the character string
    \code{"Bartlett test of homogeneity of variances"}.}
  \item{data.name}{a character string giving the names of the data.}
}
\description{
A note to the user about the validity of assumptions for the
default linear model.
}
\examples{

# getting message
ggstatsplot::bartlett_message(
  data = iris,
  x = Species,
  y = Sepal.Length,
  lab = "Iris Species"
)

# getting results from the test
ggstatsplot::bartlett_message(
  data = mtcars,
  x = am,
  y = wt,
  output = "tidy"
)
}
\seealso{
\code{\link{ggbetweenstats}}

Other helper_messages: \code{\link{normality_message}()}
}
\concept{helper_messages}
