% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstatsplot-package.R
\docType{package}
\name{ggstatsplot-package}
\alias{ggstatsplot-package}
\alias{_PACKAGE}
\alias{ggstatsplot}
\title{ggstatsplot: 'ggplot2' Based Plots with Statistical Details}
\description{
\code{ggstatsplot} is an extension of \code{ggplot2} package for creating
graphics with details from statistical tests included in the plots
themselves and targeted primarily at behavioral sciences community to
provide a one-line code to produce information-rich plots. In a typical
exploratory data analysis workflow, data visualization and statistical
modelling are two different phases: visualization informs modelling, and
modelling in its turn can suggest a different visualization method, and so
on and so forth. The central idea of ggstatsplot is simple: combine these
two phases into one in the form of graphics with statistical details, which
makes data exploration simpler and faster. Currently, it supports only the
most common types of statistical tests (parametric, nonparametric,
bayesian, and robust versions of t-test/anova, correlation, regression, and
contingency tables analyses).
}
\details{
\code{ggstatsplot}

The main functions are-
\itemize{
\item \code{\link[ggstatsplot]{ggbetweenstats}} function to produce
information-rich comparison plot between different groups or conditions
with \code{ggplot2} and details from the statistical tests in the subtitle.
\item \code{\link[ggstatsplot]{ggscatterstats}} function to produce
\code{ggplot2} scatterplots along with a marginal histograms/boxplots/density
plots from \code{ggExtra} and details from the statistical tests in the
subtitle.
\item \code{\link[ggstatsplot]{ggpiestats}} function to produce pie chart
with details from the statistical tests in the subtitle.
\item \code{\link[ggstatsplot]{gghistostats}} function to produce histogram
for a single variable with results from one sample test displayed in the
subtitle.
\item \code{\link[ggstatsplot]{ggdotplotstats}} function to produce
Cleveland-style dot plots/charts for a single variable with labels and
results from one sample test displayed in the subtitle.
\item \code{\link[ggstatsplot]{ggcorrmat}} function to visualize the
correlation matrix.
\item \code{\link[ggstatsplot]{ggcoefstats}} function to visualize
results from regression analyses.
\item \code{\link[ggstatsplot]{combine_plots}} helper function to combine
multiple \code{ggstatsplot} plots using \code{cowplot::plot_grid()} with a
combination of title, caption, and annotation label.
\item \code{\link[ggstatsplot]{theme_ggstatsplot}} default theme used for
this package.
}

For more documentation, see the dedicated
\href{https://indrajeetpatil.github.io/ggstatsplot/}{Website}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://indrajeetpatil.github.io/ggstatsplot/}
  \item \url{https://github.com/IndrajeetPatil/ggstatsplot}
  \item Report bugs at \url{https://github.com/IndrajeetPatil/ggstatsplot/issues}
}

}
\author{
\strong{Maintainer}: Indrajeet Patil \email{patilindrajeet.science@gmail.com} (0000-0003-1995-6531)

Other contributors:
\itemize{
  \item Chuck Powell \email{ibecav@gmail.com} (0000-0002-3606-2188) [contributor]
}

}
