% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatterstats.R
\name{ggscatterstats}
\alias{ggscatterstats}
\title{Scatterplot with marginal distributions}
\usage{
ggscatterstats(data, x, y, xlab = NULL, ylab = NULL, line.size = 1.5,
  line.color = "blue", marginal = TRUE, marginal.type = "histogram",
  marginal.size = 5, margins = c("both", "x", "y"),
  width.jitter = NULL, height.jitter = NULL, xfill = "#009E73",
  yfill = "#D55E00", xalpha = 1, yalpha = 1, xsize = 0.7,
  ysize = 0.7, centrality.para = NULL, type = "pearson",
  results.subtitle = NULL, title = NULL, caption = NULL,
  nboot = 100, beta = 0.1, k = 3, axes.range.restrict = FALSE,
  ggtheme = ggplot2::theme_bw(), messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{A vector containing the explanatory variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{line.size}{Size for the regression line.}

\item{line.color}{color for the regression line.}

\item{marginal}{Decides whether \code{ggExtra::ggMarginal()} plots will be
displayed; the default is \code{TRUE}.}

\item{marginal.type}{Type of marginal distribution to be plotted on the axes
(\code{"histogram"}, \code{"boxplot"}, \code{"density"}, \code{"violin"}, \code{"densigram"}).}

\item{marginal.size}{Integer describing the relative size of the marginal
plots compared to the main plot. A size of \code{5} means that the main plot is
5x wider and 5x taller than the marginal plots.}

\item{margins}{Character describing along which margins to show the plots.
Any of the following arguments are accepted: \code{"both"}, \code{"x"}, \code{"y"}.}

\item{width.jitter}{Degree of jitter in \code{x} direction. Defaults to 40\% of
the resolution of the data.}

\item{height.jitter}{Degree of jitter in \code{y} direction. Defaults to 40\% of
the resolution of the data.}

\item{xfill, yfill}{Character describing color fill for \code{x} and \code{y} axes
marginal distributions (default: \code{"#009E73"} (for \code{x}) and \code{"#D55E00"} (for
\code{y})).}

\item{xalpha, yalpha}{Numeric deciding transparency levels for the marginal
distributions. Any numbers from \code{0} (transparent) to \code{1} (opaque). The
default is \code{1} for both axes.}

\item{xsize, ysize}{Size for the marginal distribution boundaries (Default: \code{0.7}).}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as vertical (for \code{x}) and horizontal (for
\code{y}) lines.}

\item{type}{Type of association between paired samples required
("\code{"parametric"}: Pearson's product moment correlation coefficient" or
"\code{"nonparametric"}: Spearman's rho" or "\code{"robust"}: Robust regression using
an M estimator"). Corresponding abbreviations are also accepted: \code{"p"} (for
parametric/pearson's), \code{"np"} (nonparametric/spearman), \code{"r"} (robust),
resp.}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as subtitle.}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{beta}{bending constant (Default: \code{0.1}). For more, see \code{?WRS2::pbcor}.}

\item{k}{Number of decimal places expected for results.}

\item{axes.range.restrict}{Logical decides whether to restrict the axes values
ranges to min and max values of the \code{x} and \code{y} variables (Default: \code{FALSE}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Allowed values are the official \code{ggplot2} themes,
including \code{theme_grey()}, \code{theme_minimal()}, \code{theme_classic()},
\code{theme_void()}, etc.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Scatterplots from \code{ggplot2} combined with marginal
histograms/boxplots/density plots with statistical details added as a
subtitle.
}
\note{
\code{marginal.type = "densigram"} will work only with the development
version of \code{ggExtra} that you can download from \code{GitHub}:
\code{devtools::install_github("daattali/ggExtra")}
}
\examples{

# to get reproducible results from bootstrapping
set.seed(123)

# simple function call with the defaults
ggstatsplot::ggscatterstats(
  data = datasets::mtcars,
  x = wt,
  y = mpg,
  type = "np"
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/ggscatterstats.html}
}
\seealso{
\code{\link{grouped_ggscatterstats}} \code{\link{ggcorrmat}} \code{\link{grouped_ggcorrmat}}
}
\author{
Indrajeet Patil
}
