% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbetweenstats.R
\name{ggbetweenstats}
\alias{ggbetweenstats}
\title{violin plots for group or condition comparisons}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"}).Corresponding abbreviations are also accepted: \code{"p"} (for
parametric), \code{"np"} (nonparametric), \code{"r"} (robust), resp.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests
(\code{"biased"} (Cohen's \emph{d} for \strong{t-test}; partial eta-squared for \strong{anova})
or \code{"unbiased"} (Hedge's \emph{g} for \strong{t-test}; partial omega-squared for
\strong{anova})).}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{k}{Number of decimal places expected for results.}

\item{var.equal}{A logical variable indicating whether to treat the two
variances as being equal (Default: \code{FALSE}).}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{outlier.color}{Default aesthetics for outliers.}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged.}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey’s method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{mean.plotting}{Decides whether mean is to be highlighted and its value
to be displayed (Default: \code{TRUE}).}

\item{mean.color}{Color for the data point corresponding to mean.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Violin plots for between-subjects designs with statistical
details included in the plot as a subtitle.
}
\examples{

# to get reproducible results from bootstrapping
set.seed(123)

# simple function call with the defaults
ggstatsplot::ggbetweenstats(
data = datasets::iris,
x = Species,
y = Sepal.Length
)

# more detailed function call
ggstatsplot::ggbetweenstats(
data = datasets::ToothGrowth,
x = supp,
y = len,
xlab = "Supplement type",
ylab = "Tooth length",
outlier.tagging = TRUE)

}
\author{
Indrajeet Patil
}
