% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{scale_y_Rfr_continuous}
\alias{scale_y_Rfr_continuous}
\alias{scale_y_Rfr_specular_continuous}
\alias{scale_y_Rfr_total_continuous}
\title{Reflectance y-scale}
\usage{
scale_y_Rfr_continuous(
  unit.exponent = 0,
  name = Rfr_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1), Rfr.type = Rfr.type),
  labels = SI_pl_format(exponent = unit.exponent),
  limits = c(0, 1),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  Rfr.type,
  ...
)

scale_y_Rfr_specular_continuous(
  unit.exponent = 0,
  name = Rfr_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1), Rfr.type =
    "specular"),
  labels = SI_pl_format(exponent = unit.exponent),
  limits = c(0, 1),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  ...
)

scale_y_Rfr_total_continuous(
  unit.exponent = 0,
  name = Rfr_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1), Rfr.type = "total"),
  labels = SI_pl_format(exponent = unit.exponent),
  limits = c(0, 1),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{limits}{One of \code{NULL} for default based on data range, a numeric
vector of length two (\code{NA} allowed) or a function that accepts the
data-based limits as argument and returns new limits.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{Rfr.type}{character, either "total" or "spcular".}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for spectral reflectance.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(Ler_leaf_rflt.spct) +
  geom_line() +
  scale_y_Rfr_continuous(Rfr.type = getRfrType(Ler_leaf_rflt.spct)) +
  scale_x_wl_continuous()

ggplot(Ler_leaf_rflt.spct) +
  geom_line() +
  scale_y_Rfr_continuous(unit.exponent = -2,
                         Rfr.type = getRfrType(Ler_leaf_rflt.spct)) +
  scale_x_wl_continuous()

ggplot(Ler_leaf_rflt.spct) +
  geom_line() +
  scale_y_Rfr_continuous(unit.exponent = -3,
                         Rfr.type = getRfrType(Ler_leaf_rflt.spct)) +
  scale_x_wl_continuous()

ggplot(Ler_leaf_rflt.spct) +
  geom_line() +
  scale_y_Rfr_specular_continuous() +
  scale_x_wl_continuous()

}
