% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-waveband.R
\name{autoplot.waveband}
\alias{autoplot.waveband}
\title{Create a complete ggplot for a waveband descriptor.}
\usage{
\method{autoplot}{waveband}(
  object,
  ...,
  w.length = NULL,
  range = c(280, 800),
  fill = 0,
  span = NULL,
  wls.target = "HM",
  unit.in = getOption("photobiology.radiation.unit", default = "energy"),
  annotations = NULL,
  wb.trim = TRUE,
  norm = NULL,
  text.size = 2.5,
  ylim = c(NA, NA),
  object.label = deparse(substitute(object)),
  na.rm = TRUE
)
}
\arguments{
\item{object}{a waveband object.}

\item{...}{currently ignored.}

\item{w.length}{numeric vector of wavelengths (nm)}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm).}

\item{fill}{value to use as response for wavelngths outside the waveband
range.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{unit.in}{the type of unit we assume as reference "energy" or "photon"
based.}

\item{annotations}{a character vector.}

\item{wb.trim}{logical.}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{ylim}{numeric y axis limits,}

\item{object.label}{character The name of the object being plotted.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
\code{waveband} object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot object, and can be further manipulated.

Effectiveness spectra are plotted expressing the spectral effectiveness
either as $1 mol^{-1} nm$ photons of $1 J^{-1} nm$ which can selected through
formal argument \code{unit.out}. The value of \code{unit.in} has no effect on
the result when uisng BSWFs, as BSWFs are defined based on a certain base of
expression, which is enforced. In contrast, for wavebands which only define a
wavelength range, changing the assumed reference irradiance, changes the
responsivity according to Plank's law.

This function creates a response_spct object from the waveband object and
plots it. Unused arguments are passed along, which means that other plot
aspects can be controlled by providing arguments for the plot method of the
response_spct class.
}
\examples{

autoplot(waveband(c(400, 500)))

}
\seealso{
Other autoplot methods: 
\code{\link{autoplot.calibration_spct}()},
\code{\link{autoplot.cps_spct}()},
\code{\link{autoplot.filter_spct}()},
\code{\link{autoplot.object_spct}()},
\code{\link{autoplot.raw_spct}()},
\code{\link{autoplot.reflector_spct}()},
\code{\link{autoplot.response_spct}()},
\code{\link{autoplot.source_spct}()},
\code{\link{set_annotations_default}()}
}
\concept{autoplot methods}
\keyword{hplot}
