% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-cps-spct.r
\name{cps_plot}
\alias{cps_plot}
\title{Create a complete ggplot for detector-counts per second spectra.}
\usage{
cps_plot(spct, w.band, range, pc.out, label.qty, span, annotations, norm,
  text.size, idfactor, ylim, na.rm, ...)
}
\arguments{
\item{spct}{a cps_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
cps_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot object, and can be further manipulated.
  When spct has more than one column with spectral data, each of these
  columns is normalized individually.
}
\keyword{internal}
