% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-source-spct.R
\name{s.e.irrad_label}
\alias{s.e.irrad_label}
\alias{s.q.irrad_label}
\title{spectral irradiance axis labels}
\usage{
s.e.irrad_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.irrad"]],
  scaled = FALSE,
  normalized = FALSE
)

s.q.irrad_label(
  unit.exponent = ifelse(normalized, 0, -6),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.irrad"]],
  scaled = FALSE,
  normalized = FALSE
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}
}
\value{
a character string or an R expression.
}
\description{
Generate axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

counts_label()
counts_label("R.expression")
counts_label("LaTeX")

}
