% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{sec_axis_w_number}
\alias{sec_axis_w_number}
\alias{sec_axis_w_frequency}
\title{Secondary axes for wavelengths}
\usage{
sec_axis_w_number(unit.exponent = -6)

sec_axis_w_frequency(unit.exponent = 12)
}
\arguments{
\item{unit.exponent}{integer}
}
\description{
Secondary axes for wavelength data in nanometres. With suitable scaling and
name (axis label) for frequency and wavenumber.
}
\examples{
library(ggplot2)
library(photobiology)

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number())

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(-4))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(nearest_SI_exponent(-4)))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(-3))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_frequency())

}
