% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spraster.R
\name{annotation_spraster}
\alias{annotation_spraster}
\alias{geom_spraster_rgb}
\title{Annotation raster using Raster* layers}
\usage{
annotation_spraster(raster, interpolate = FALSE, na.value = NA)

geom_spraster_rgb(raster, interpolate = FALSE, na.value = NA)
}
\arguments{
\item{raster}{A Raster* object}

\item{interpolate}{TRUE to interpolate rendering}

\item{na.value}{A value to represent NAs, since a transparency band
may or may not exist for this raster. If na.value = NA, a transparency
band will be created to remove missing values from display.}
}
\value{
An annotation layer or list of layers (geom_spraster_rgb)
}
\description{
This is a thin wrapper around \link[ggplot2]{annotation_raster}, with the
bounds arguments filled in using the bounds of the raster. Like annotation_raster,
this will not adjust the extents of the plot. The coordinates used are in
the coordinate system of the raster, which are likely not lat/lon.
}
\examples{
ggplot() +
  annotation_spraster(longlake_osm) +
  geom_spatial(longlake_waterdf, toepsg = 26920) +
  coord_fixed()


}

