% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecosystem_services.r
\docType{data}
\name{ecosystem_services}
\alias{ecosystem_services}
\alias{ecosystem_services_pivot1}
\alias{ecosystem_services_pivot2}
\title{Data on risks to supply ecosystem services}
\format{
\code{ecosystem_services} is  a \code{data.frame} with
3421 rows and 8 columns.
The columns are:
\itemize{
\item \code{activity_type}: Type of activities that pose a risk
\item \code{activity_realm}: Aggregation of activity types
\item \code{pressure_cat}: Category of pressures exerted by the activities and
eventually pose a risk to the ecosystem.
\item \code{biotic_group}: Biotic groups affected by the pressures.
\item \code{biotic_realm}: Aggregation of biotic groups
\item \code{service_division}: Division of ecosystem services that are
provided by the biotic groups and affected by the activities.
\item \code{service_section}: Aggregation of service divisions.
\item \code{RCSES}: 'Risk to Capacity to Supply Ecosystem Services'.
A numerical score reflecting the amount of risk for the ecosystem to
supply specific services. For more details see Piet et al. (submitted)
}

This \code{data.frame} is in a wide oriented format, typical for most common
applications. Each row in the \code{data.frame} represents a unique pathway where each
\code{activity_tpe} poses a risk to an ecosystem \code{sevice_division}, via a
\code{pressure_cat} and \code{biotic_group}. Each column either contains information on
a specific stage or the overall quantifier (in this case \code{RCSES}).

In its present form it is not suitable to directly plot as a Sankey diagram.
For that purpose it needs to be pivoted with \code{\link[=pivot_stages_longer]{pivot_stages_longer()}}. Two
different variants are prepared with this function: \code{ecosystem_services_pivot1}
and \code{ecosystem_services_pivot2}.

The latter pivot contains \code{service_section} as an extra feature which can be used
for additional decoration of a Sankey diagram. It is therefore more detailed than
the first alternative.

\code{ecosystem_services_pivot1} is  a \code{data.frame} with
112 rows and 5
columns. Columns are:
\itemize{
\item \code{RCSES}: See above at \code{ecosystem_services}.
\item \code{edge_id}: Unique numerical identifier for each edge in a Sankey diagram.
\item \code{connector}: One of \code{'from'} or \code{'to'}, indicating whether we are looking
at the start or the end of an edge.
\item \code{node}: A collection of \code{activity_realm}, \code{pressure_cat}, \code{biotic_realm} and
\code{service_section} values from the \code{ecosystem_services} \code{data.frame}.
\item \code{stage}: Stages in a Sankey diagram formed by the columns \code{activity_realm},
\code{pressure_cat}, \code{biotic_realm} and \code{service_section} from the
\code{ecosystem_services} \code{data.frame}.
}

\code{ecosystem_services_pivot1} is created from \code{ecosystem_services} using
\code{\link[=pivot_stages_longer]{pivot_stages_longer()}} and can be used directly in a Sankey diagram (using
\code{\link[=geom_sankeynode]{geom_sankeynode()}} and \code{\link[=geom_sankeyedge]{geom_sankeyedge()}})

\code{ecosystem_services_pivot2} is  a \code{data.frame} with
252 rows and 6.
It is the same as \code{ecosystem_services_pivot1} with the exception of a distinct
extra column \code{service_division} which allows for more detailed aesthetics in
a Sankey diagram.
}
\description{
Data indicating a risk resulting from anthropological activities to the
marine ecosystem and its capacity to supply services.
This data set serves (aggregated from Piet \emph{et al.} (submitted)) as an example
to illustrate the package's features.
}
\examples{
data("ecosystem_services")
library(ggplot2)

if (requireNamespace("stringr")) {
  library(stringr)

  pos <- position_sankey(v_space = "auto", align = "justify")
  pos_text <- position_sankey(v_space = "auto", align = "justify", nudge_x = 0.1)

  ## A simplified version of the Sankey diagram as published by Piet _et al._ (submitted)
  ggplot(ecosystem_services |>
           pivot_stages_longer(
             c("activity_type", "pressure_cat", "biotic_group", "service_section"),
             "RCSES"),
         aes(x = stage, y = RCSES, group = node, connector = connector, edge_id = edge_id)) +
    geom_sankeyedge(aes(fill = RCSES), position = pos) +
    geom_sankeynode(position = pos) +
    geom_text(aes(label = str_wrap(node, 20)), position = pos_text, stat = "sankeynode",
              hjust = 0, cex = 2) +
    scale_fill_viridis_c(option = "turbo", trans = "sqrt") +
    theme_minimal()
}
}
\references{
Piet GJ, Bentley J, Jongbloed RH, Grundlehner A, Tamis JE, De Vries P
(submitted) A Cumulative Impact Assessment on the North Sea Capacity to
Supply Ecosystem Services. \doi{10.2139/ssrn.4450241}
}
\author{
Pepijn de Vries, Gerjan Piet, Jacob Bentley, Ruud Jongbloed, Anne Grundlehner, Jacqueline Tamis
}
