% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspring.R
\name{offspring}
\alias{offspring}
\title{Descendants of an individual per generation}
\usage{
offspring(ped, id, pheno)
}
\arguments{
\item{ped}{: \code{data.frame} with columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{id}{: The ID of the individual, for which the descendants to be extracted.}

\item{pheno}{: Vector of phenotyped individuals.}
}
\value{
prgn : \code{list} of progeny per generation.

prgn.ph : \code{list} of phenotyped progeny per generation.
}
\description{
Counts and collects progeny and phenotyped progeny of an individual in successive generations.
}
\examples{
ped = data.frame(V1 = 1:19,
   V2 = c(0,0,1,1,0,0,0,0,0,4,5,5,7,0,0,9,0,0,12),
   V3 = c(0,0,0,2,0,2,0,3,3,3,0,6,8,8,8,10,11,11,0))
pheno = 10:18
# Find progeny and phenotyped progeny of individual 1.
offspring(ped, 1, pheno)
# Find phenotyped progeny of individual 1, in the 2nd generation.
offspring(ped, 1, 10:18)$prgn.ph[[2]]
# If only interested in finding the progeny of individual 1:
offspring(ped, 1, c())$prgn

}
