# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Euclidean distance between two numeric vectors.
#' @param p1 A numeric vector.
#' @param p2 A numeric vector.
euclid <- function(p1, p2) {
    .Call('ggrepel_euclid', PACKAGE = 'ggrepel', p1, p2)
}

#' Find the intersections between a line and a rectangle.
#' @param p1 A point like \code{c(x, y)}
#' @param p2 A point like \code{c(x, y)}
#' @param b A rectangle like \code{c(x1, y1, x2, y2)}
intersect_line_rectangle <- function(p1, p2, b) {
    .Call('ggrepel_intersect_line_rectangle', PACKAGE = 'ggrepel', p1, p2, b)
}

#' Move a box into the area specificied by x limits and y limits.
#' @param b A numeric vector representing a box like \code{c(x1, y1, x2, y2)}
#' @param xlim A numeric vector representing the limits on the x axis like
#'   \code{c(xmin, xmax)}
#' @param ylim A numeric vector representing the limits on the y axis like
#'   \code{c(ymin, ymax)}
put_within_bounds <- function(b, xlim, ylim) {
    .Call('ggrepel_put_within_bounds', PACKAGE = 'ggrepel', b, xlim, ylim)
}

#' Get the coordinates of the center of a box.
#' @param b A numeric vector representing a box like \code{c(x1, y1, x2, y2)}
centroid <- function(b) {
    .Call('ggrepel_centroid', PACKAGE = 'ggrepel', b)
}

#' Test if a box overlaps another box.
#' @param a A numeric vector representing a box like \code{c(x1, y1, x2, y2)}
#' @param b A numeric vector representing a box like \code{c(x1, y1, x2, y2)}
overlaps <- function(a, b) {
    .Call('ggrepel_overlaps', PACKAGE = 'ggrepel', a, b)
}

#' Test if a point is within the boundaries of a box.
#' @param p A point like \code{c(x, y)}
#' @param b A numeric vector representing a box like \code{c(x1, y1, x2, y2)}
point_within_box <- function(p, b) {
    .Call('ggrepel_point_within_box', PACKAGE = 'ggrepel', p, b)
}

#' Compute the repulsion force upon point \code{a} from point \code{b}.
#'
#' The force decays with the squared distance between the points, similar
#' to the force of repulsion between magnets.
#'
#' @param a A point like \code{c(x, y)}
#' @param b A point like \code{c(x, y)}
#' @param force Magnitude of the force (defaults to \code{1e-6})
repel_force <- function(a, b, force = 0.000001) {
    .Call('ggrepel_repel_force', PACKAGE = 'ggrepel', a, b, force)
}

#' Compute the spring force upon point \code{a} from point \code{b}.
#'
#' The force increases with the distance between the points, similar
#' to Hooke's law for springs.
#'
#' @param a A point like \code{c(x, y)}
#' @param b A point like \code{c(x, y)}
#' @param force Magnitude of the force (defaults to \code{1e-6})
spring_force <- function(a, b, force = 0.000001) {
    .Call('ggrepel_spring_force', PACKAGE = 'ggrepel', a, b, force)
}

#' Adjust the layout of a list of potentially overlapping boxes.
#' @param boxes A list of numeric vectors representing a box like
#'   \code{list(c(x1, y1, x2, y2), c(x1, y1, x2, y2), ...)}
#' @param xlim A numeric vector representing the limits on the x axis like
#'   \code{c(xmin, xmax)}
#' @param ylim A numeric vector representing the limits on the y axis like
#'   \code{c(ymin, ymax)}
#' @param force Magnitude of the force (defaults to \code{1e-6})
#' @param maxiter Maximum number of iterations to try to resolve overlaps
#'   (defaults to 2000)
repel_boxes <- function(boxes, xlim, ylim, force = 1e-6, maxiter = 2000L) {
    .Call('ggrepel_repel_boxes', PACKAGE = 'ggrepel', boxes, xlim, ylim, force, maxiter)
}

