% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_fill.R
\name{scale_edge_fill}
\alias{scale_edge_fill}
\alias{scale_edge_fill_hue}
\alias{scale_edge_fill_brewer}
\alias{scale_edge_fill_distiller}
\alias{scale_edge_fill_gradient}
\alias{scale_edge_fill_gradient2}
\alias{scale_edge_fill_gradientn}
\alias{scale_edge_fill_grey}
\alias{scale_edge_fill_identity}
\alias{scale_edge_fill_manual}
\alias{scale_edge_fill_viridis}
\alias{scale_edge_fill_continuous}
\alias{scale_edge_fill_discrete}
\title{Edge fill scales}
\usage{
scale_edge_fill_hue(..., h = c(0, 360) + 15, c = 100, l = 65,
  h.start = 0, direction = 1, na.value = "grey50")

scale_edge_fill_brewer(..., type = "seq", palette = 1, direction = 1)

scale_edge_fill_distiller(..., type = "seq", palette = 1, direction = -1,
  values = NULL, space = "Lab", na.value = "grey50",
  guide = "edge_colourbar")

scale_edge_fill_gradient(..., low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "grey50", guide = "edge_colourbar")

scale_edge_fill_gradient2(..., low = muted("red"), mid = "white",
  high = muted("blue"), midpoint = 0, space = "Lab",
  na.value = "grey50", guide = "edge_colourbar")

scale_edge_fill_gradientn(..., colours, values = NULL, space = "Lab",
  na.value = "grey50", guide = "edge_colourbar", colors)

scale_edge_fill_grey(..., start = 0.2, end = 0.8, na.value = "red")

scale_edge_fill_identity(..., guide = "none")

scale_edge_fill_manual(..., values)

scale_edge_fill_viridis(..., alpha = 1, begin = 0, end = 1,
  discrete = FALSE, option = "D", direction = 1)

scale_edge_fill_continuous(..., low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "grey50", guide = "edge_colourbar")

scale_edge_fill_discrete(..., h = c(0, 360) + 15, c = 100, l = 65,
  h.start = 0, direction = 1, na.value = "grey50")
}
\arguments{
\item{...}{Arguments passed on to \code{discrete_scale}
\describe{
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{limits}{A character vector that defines possible values of the scale
and their order.}
  \item{drop}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
  \item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
  \item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take}
  \item{name}{The name of the scale. Used as axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
  \item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
  \item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}
  \item{super}{The super class to use for the constructed scale}
}}

\item{h}{range of hues to use, in [0, 360]}

\item{c}{chroma (intensity of colour), maximum value varies depending on
combination of hue and luminance.}

\item{l}{luminance (lightness), in [0, 100]}

\item{h.start}{hue to start at}

\item{direction}{direction to travel around the colour wheel,
1 = clockwise, -1 = counter-clockwise}

\item{na.value}{Colour to use for missing values}

\item{type}{One of seq (sequential), div (diverging) or qual (qualitative)}

\item{palette}{If a string, will use that named palette.  If a number, will
index into the list of palettes of appropriate \code{type}}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[=rescale]{rescale()}} for a convience function
to map an arbitrary range to between 0 and 1.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}

\item{low, high}{Colours for low and high ends of the gradient.}

\item{mid}{colour for mid point}

\item{midpoint}{The midpoint (in data value) of the diverging scale.
Defaults to 0.}

\item{colours, colors}{Vector of colours to use for n-colour gradient.}

\item{start}{gray value at low end of palette}

\item{end}{gray value at high end of palette}

\item{alpha}{pass through parameter to \code{viridis}}

\item{begin}{The (corrected) hue in [0,1] at which the viridis colormap begins.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{option}{A character string indicating the colormap option to use. Four
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"),
"viridis" (or "D", the default option) and "cividis" (or "E").}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new fill scales for edge geoms equivalent to the
ones already defined by ggplot2. The parameters are equivalent to the ones
from ggplot2 so there is nothing new under the sun. The different geoms will
know whether to use edge scales or the standard scales so it is not necessary
to write \code{edge_fill} in the call to the geom - just use \code{fill}.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_shape}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_edge_width}},
  \code{\link{scale_label_size}}
}
\concept{scale_edge_*}
