% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_size.R
\name{scale_edge_size}
\alias{scale_edge_size}
\alias{scale_edge_size_continuous}
\alias{scale_edge_radius}
\alias{scale_edge_size}
\alias{scale_edge_size_discrete}
\alias{scale_edge_size_area}
\alias{scale_edge_size_manual}
\alias{scale_edge_size_identity}
\title{Edge size scales}
\usage{
scale_edge_size_continuous(..., range = c(1, 6))

scale_edge_radius(..., range = c(1, 6))

scale_edge_size(..., range = c(1, 6))

scale_edge_size_discrete(..., range = c(2, 6))

scale_edge_size_area(..., max_size = 6)

scale_edge_size_manual(..., values)

scale_edge_size_identity(..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
to control name, limits, breaks, labels and so forth.}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{max_size}{Size of largest points.}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Name of guide object, or object itself.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new size scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2]{scale_size}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_size} in
the call to the geom - just use \code{size}.
}
\note{
In ggplot2 size conflates both line width and point size into one
scale. In ggraph there is also a width scale (\code{\link{scale_edge_width}})
that is used for linewidth. As edges are often represented by lines the width
scale is the most common.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_shape}},
  \code{\link{scale_edge_width}},
  \code{\link{scale_label_size}}
}
