% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_label_size.R
\name{scale_label_size}
\alias{scale_label_size}
\alias{scale_label_size_continuous}
\alias{scale_label_size}
\alias{scale_label_size_discrete}
\alias{scale_label_size_manual}
\alias{scale_label_size_identity}
\title{Edge label size scales}
\usage{
scale_label_size_continuous(..., range = c(1, 6))

scale_label_size(..., range = c(1, 6))

scale_label_size_discrete(..., range = c(2, 6))

scale_label_size_manual(..., values)

scale_label_size_identity(..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
to control name, limits, breaks, labels and so forth.}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Name of guide object, or object itself.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new size scales for edge labels in order to allow
for separate sizing of edges and their labels.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_shape}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_edge_width}}
}
