% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_arcbar.R, R/stat-arcbar.R
\name{geom_arcbar}
\alias{geom_arcbar}
\alias{stat_arcbar}
\title{Create an Arc-Barchart}
\usage{
geom_arcbar(mapping = NULL, data = NULL, stat = "arcbar",
  position = "identity", n = 360, sep = 0.05, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)

stat_arcbar(mapping = NULL, data = NULL, geom = "arcbar",
  position = "identity", n = 360, sep = 0.05, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{n}{The number of}

\item{sep}{Separation between the different shares, as a total proportion of pi.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom}{The geometric object to use display the data}
}
\description{
An arc bar diagram that allows for spacing between the individual arc components 
and spans 180 degrees.
}
\section{Aesthetics}{

geom_arcbar understands the following aesthetics (required aesthetics are in bold):

- **shares**
- **r0** - inner radius
- **r1** - outer radius
- color
- fill
- linetype
- alpha
}

\examples{
bt <- data.frame(
  parties = factor(c("CDU", "CSU", "AfD", "FDP", "SPD", 
                     "Linke", "Gruene", "Fraktionslos"),
                   levels = c("CDU", "CSU", "AfD", "FDP", "SPD", 
                              "Linke", "Gruene", "Fraktionslos")),
  seats   = c(200, 46, 92, 80, 153, 69, 67, 2),
  colors  = c("black", "blue", "lightblue", "yellow", "red",
              "purple", "green", "grey"),
  stringsAsFactors = FALSE)

ggplot(bt) + 
  geom_arcbar(aes(shares = seats, r0 = 5, r1 = 10, fill = parties)) + 
  scale_fill_manual(values = bt$colors) +
  coord_fixed() +
  theme_void()
}
