% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.r
\name{ggsave}
\alias{ggsave}
\title{Save a ggplot (or other grid object) with sensible defaults}
\usage{
ggsave(filename, plot = last_plot(), device = NULL, path = NULL,
  scale = 1, width = NA, height = NA, units = c("in", "cm", "mm"),
  dpi = 300, limitsize = TRUE, ...)
}
\arguments{
\item{filename}{File name to create on disk.}

\item{plot}{Plot to save, defaults to last plot displayed.}

\item{device}{Device to use. Can be either be a device function
(e.g. \code{\link[=png]{png()}}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).}

\item{path}{Path to save plot to (combined with filename).}

\item{scale}{Multiplicative scaling factor.}

\item{width, height, units}{Plot size in \code{units} ("in", "cm", or "mm").
If not supplied, uses the size of current graphics device.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Applies only to raster output types.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{...}{Other arguments passed on to graphics \code{device}.}
}
\description{
\code{ggsave()} is a convenient function for saving a plot. It defaults to
saving the last plot that you displayed, using the size of the current
graphics device. It also guesses the type of graphics device from the
extension.
}
\examples{
\dontrun{
ggplot(mtcars, aes(mpg, wt)) + geom_point()

ggsave("mtcars.pdf")
ggsave("mtcars.png")

ggsave("mtcars.pdf", width = 4, height = 4)
ggsave("mtcars.pdf", width = 20, height = 20, units = "cm")

unlink("mtcars.pdf")
unlink("mtcars.png")

# specify device when saving to a file with unknown extension
# (for example a server supplied temporary file)
file <- tempfile()
ggsave(file, device = "pdf")
unlink(file)
}
}
