% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-map.r
\name{borders}
\alias{borders}
\title{Create a layer of map borders.}
\usage{
borders(database = "world", regions = ".", fill = NA, colour = "grey50",
  xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{database}{map data, see \code{\link[maps]{map}} for details}

\item{regions}{map region}

\item{fill}{fill colour}

\item{colour}{border colour}

\item{xlim, ylim}{latitudinal and logitudinal range for extracting map
polygons, see \code{\link[maps]{map}} for details.}

\item{...}{other arguments passed onto \code{\link{geom_polygon}}}
}
\description{
Create a layer of map borders.
}
\examples{
if (require("maps")) {

ia <- map_data("county", "iowa")
mid_range <- function(x) mean(range(x))
seats <- plyr::ddply(ia, "subregion", plyr::colwise(mid_range, c("lat", "long")))
ggplot(ia, aes(long, lat)) +
  geom_polygon(aes(group = group), fill = NA, colour = "grey60") +
  geom_text(aes(label = subregion), data = seats, size = 2, angle = 45)

data(us.cities)
capitals <- subset(us.cities, capital == 2)
ggplot(capitals, aes(long, lat)) +
  borders("state") +
  geom_point(aes(size = pop)) +
  scale_size_area() +
  coord_quickmap()

# Same map, with some world context
ggplot(capitals, aes(long, lat)) +
  borders("world", xlim = c(-130, -60), ylim = c(20, 50)) +
  geom_point(aes(size = pop)) +
  scale_size_area() +
  coord_quickmap()
}
}

