\name{geom_hline}
\alias{geom_hline}
\alias{GeomHline}
\title{geom\_hline}
\description{Line, horizontal}
\details{
This geom allows you to annotate the plot with horizontal lines (see geom\_vline and geom\_abline for other types of lines)


There are two ways to use it.  You can either specify the intercept of the line in the call to the geom, in which case the line will be in the same position in every panel.  Alternatively, you can supply a different intercept for each panel using a data.frame.  See the examples for the differences

This page describes geom\_hline, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_hline.  Aesthetics are mapped to variables in the data with the aes function: \code{geom\_hline(aes(x = var))}
\itemize{
  \item \code{colour}: border colour 
  \item \code{size}: size 
  \item \code{linetype}: line type 
  \item \code{alpha}: transparency 
}
}
\usage{geom_hline(mapping=NULL, data=NULL, stat="hline", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \code{\link{geom_vline}}: for vertical lines
  \item \code{\link{geom_abline}}: for lines defined by a slope and intercept
  \item \code{\link{geom_segment}}: for a more general approach
  \item \url{http://had.co.nz/ggplot2/geom_hline.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
p <- ggplot(mtcars, aes(x = wt, y=mpg)) + geom_point()

p + geom_hline(aes(yintercept=mpg))
p + geom_hline(yintercept=20)
p + geom_hline(yintercept=seq(10, 30, by=5))

# To display different lines in different facets, you need to 
# create a data frame.
p <- qplot(mpg, wt, data=mtcars, facets = vs ~ am)

hline.data <- data.frame(z = 1:4, vs = c(0,0,1,1), am = c(0,1,0,1))
p + geom_hline(aes(yintercept = z), hline.data)
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
