% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_daa_results.R
\name{compare_daa_results}
\alias{compare_daa_results}
\title{Compare the Consistency of Statistically Significant Features}
\arguments{
\item{daa_results_list}{A list of data frames containing statistically significant features obtained using different methods.}

\item{method_names}{A character vector of names for each method used.}

\item{p_values_threshold}{A numeric value representing the threshold for the p-values. Features with p-values less than this
threshold are considered statistically significant. Default is 0.05.}
}
\value{
A data frame with the comparison results. The data frame has the following columns:
\itemize{
  \item \code{method}: The name of the method.
  \item \code{num_features}: The total number of statistically significant features obtained by the method.
  \item \code{num_common_features}: The number of features that are common to other methods.
  \item \code{num_diff_features}: The number of features that are different from other methods.
  \item \code{diff_features}: The names of the features that are different from other methods.
}
}
\description{
This function compares the consistency and inconsistency of statistically significant features obtained
using different methods in `pathway_daa` from the `ggpicrust2` package. It creates a report showing the number of common and
different features identified by each method, and the features themselves.
}
\examples{
\donttest{
library(magrittr)
library(ggpicrust2)
library(tibble)
data("metacyc_abundance")
data("metadata")

# Run pathway_daa function for multiple methods
methods <- c("ALDEx2", "DESeq2", "edgeR")
daa_results_list <- lapply(methods, function(method) {
pathway_daa(abundance = metacyc_abundance \%>\% column_to_rownames("pathway"),
metadata = metadata, group = "Environment", daa_method = method)
})

# Compare results across different methods
comparison_results <- compare_daa_results(daa_results_list = daa_results_list,
method_names = c("ALDEx2_Welch's t test","ALDEx2_Wilcoxon rank test","DESeq2", "edgeR"))
}
}
