% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodic.R
\name{periodic}
\alias{periodic}
\alias{periodic.default}
\alias{periodic.data.frame}
\title{Add or remove periodic variables}
\usage{
periodic(object, ...)

\method{periodic}{default}(object, period, ...)

\method{periodic}{data.frame}(object, ...)
}
\arguments{
\item{object}{the object to coerce to periodic}

\item{...}{name-value pairs of expressions defining the period}

\item{period}{a numeric vector whose range defines the period}
}
\description{
Creates a periodic object by specifying the periodic variables and their
periods.
}
\details{
This is a generic function and ggperiodic provides methods for vectors, data frames
and ggplot2 Layers (geoms and stats).
}
\examples{
library(ggplot2)

x <- seq(0, 360 - 20, by = 20)
df <- data.frame(x = x, y = cos(x*pi/180))
df_p <- periodic(df, x = c(0, 360))

ggplot(df_p, aes(x, y)) +
   geom_line() +            # periodic data
   geom_point(data = df)    # non periodic data

# Extend domain
ggplot(df_p, aes(x, y), x = c(-180, 540)) +
   geom_line() +
   geom_point(data = df)

# with non regular intervals
x <- runif(30, 0, 360)
df <- periodic(data.frame(x = x, y = cos(x*pi/180)),
               x = c(0, 360))
ggplot(df, aes(x, y), x = c(-180, 540)) +
   geom_point()

}
