% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_pacman.R
\name{animate_pacman}
\alias{animate_pacman}
\title{Create a Pac-Man Game GIF}
\usage{
animate_pacman(
  pacman,
  ghosts,
  file = NULL,
  caption = iconv("© Mickaël 'Coeos' Canouil", "UTF-8"),
  font_family = ""
)
}
\arguments{
\item{pacman}{A \code{data.frame} with the coordinates of Pac-Man moves.}

\item{ghosts}{A \code{list}of \code{data.frame} with the coordinates of (each) Ghost moves.}

\item{file}{File name to save GIF on disk.}

\item{caption}{A caption to add below the GIF.}

\item{font_family}{The font family to use for the caption.}
}
\value{
Returns a \code{gif_image} object. See \code{gganimate::gifski_renderer}.
}
\description{
Create a Pac-Man Game GIF
}
\examples{

library(ggpacman)
if (interactive()) {
  animate_pacman(pacman = pacman, ghosts = list(blinky, pinky, inky, clyde))
}

}
