% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_labels.R
\name{ord_labels}
\alias{ord_labels}
\title{Make Ordination Axis Labels}
\usage{
ord_labels(ord)
}
\arguments{
\item{ord}{A vegan ordination object.}
}
\value{
A character vector, each element of which can be used to label the corresponding axis of an ordination plot.
}
\description{
Makes ordination axis labels that include, if appropriate, the \% total variance explained by each axis.
}
\details{
If there are no eigenvalues in ord, or if any eigenvalues are less than 0, each element of the vector returned has the form "DIMn" where n is the axis number. Otherwise, each element of the vector returned has the form "AxisN xx.x\%" where "Axis" is taken from the vector of eigenvalues in ord if they are named or simply "DIM" if they are not, N is the number of the axis, and xx.x is the \% of total variance explained by the axis.
}
\examples{
data("dune")
data("dune.env")
dune_hel <- decostand(dune, method = "hellinger")
ord <- rda(dune_hel)
axis_labels <- ord_labels(ord)
axis_labels[c(1,2)]

}
