% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-serialaxes.R
\name{coord_serialaxes}
\alias{coord_serialaxes}
\title{Serial axes coordinates}
\usage{
coord_serialaxes(
  axes.layout = c("parallel", "radial"),
  scaling = c("data", "variable", "observation", "none"),
  axes.sequence = character(0L),
  positive = TRUE,
  ...
)
}
\arguments{
\item{axes.layout}{Serial axes layout, either "parallel" or "radial".}

\item{scaling}{One of \code{data}, \code{variable}, \code{observation} or
\code{none} (not suggested the layout is the same with \code{data})
to specify how the data is scaled.}

\item{axes.sequence}{A vector with variable names that defines the axes sequence.}

\item{positive}{If \code{y} is set as the density estimate, where the smoothed curved is faced to,
right (\code{positive}) or left (\code{negative}) as vertical layout;
up (\code{positive}) or down (\code{negative}) as horizontal layout?}

\item{...}{other arguments used to modify layers}
}
\value{
a \code{ggproto} object
}
\description{
It is mainly used to visualize the high dimensional data set
either on the parallel coordinate or the radial coordinate.
}
\details{
Serial axes coordinate system (parallel or radial) is different from the
Cartesian coordinate system or its transformed system (say \code{polar} in \code{ggplot2})
since it does not have a formal transformation
(i.e. in polar coordinate system, "x = rcos(theta)", "y = rsin(theta)").
In serial axes coordinate system, mapping aesthetics does not really require "x" or "y". Any "non-aesthetics"
components passed in the \code{mapping} system will be treated as an individual axis.

To project a common \code{geom} layer on such serialaxes,
users can customize function \code{\link{add_serialaxes_layers}}.
}
\section{Potential Risk}{

In package \code{ggmulti}, the function \code{ggplot_build.gg} is provided.
At the \code{ggplot} construction time, the system will call \code{ggplot_build.gg}
first. If the plot input is not a \code{CoordSerialaxes} coordinate system, the next method
\code{ggplot_build.ggplot} will be called to build a "gg" plot; else
some geometric transformations will be applied first, then the next method
\code{ggplot_build.ggplot} will be executed. So, the potential risk is, if some other packages
e.g. \code{foo}, also provide a function \code{ggplot_build.gg} that is used for their
specifications but the namespace is beyond the \code{ggmulti} (\code{ggmulti:::ggplot_build.gg} is
covered), error may occur. If so, please consider using the
\code{\link{geom_serialaxes}}.
}

\examples{
if(require("dplyr")) {
# Data
nba <- NBAstats2021 \%>\%
  mutate(
    dPTS = PTS - OPTS,
    dREB = REB - OREB,
    dAST = AST - OAST,
    dTO = TO - OTO
  )
# set sequence by `axes.sequence`
p <- ggplot(nba,
            mapping = aes(
              dPTS = dPTS,
              dREB = dREB,
              dAST = dAST,
              dTO = dTO,
              colour = Win
            )) +
       geom_path(alpha = 0.2) +
       coord_serialaxes(axes.layout = "radial") +
       scale_color_gradient(low="blue", high="red")
p
# quantile layer
p + geom_quantiles(quantiles = c(0.5),
                   colour = "green", size = 1.2)

# facet
p +
  facet_grid(Playoff ~ CONF)
}
}
