% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulkan.R
\name{ggml_vulkan_is_backend}
\alias{ggml_vulkan_is_backend}
\title{Check if backend is Vulkan}
\usage{
ggml_vulkan_is_backend(backend)
}
\arguments{
\item{backend}{Backend pointer}
}
\value{
Logical indicating if backend is Vulkan
}
\description{
Returns TRUE if the given backend is a Vulkan backend.
}
\examples{
\donttest{
if (ggml_vulkan_available() && ggml_vulkan_device_count() > 0) {
  vk_backend <- ggml_vulkan_init(0)
  cpu_backend <- ggml_backend_cpu_init()

  ggml_vulkan_is_backend(vk_backend)  # TRUE
  ggml_vulkan_is_backend(cpu_backend) # FALSE

  ggml_vulkan_free(vk_backend)
  ggml_backend_free(cpu_backend)
}
}
}
