% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_sqr}
\alias{ggml_sqr}
\title{Square (Graph)}
\usage{
ggml_sqr(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the square operation
}
\description{
Creates a graph node for element-wise squaring: x^2
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(1, 2, 3, 4))
result <- ggml_sqr(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # [1, 4, 9, 16]
ggml_free(ctx)
}
}
