% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_permute}
\alias{ggml_permute}
\title{Permute Tensor Dimensions (Graph)}
\usage{
ggml_permute(ctx, a, axis0, axis1, axis2, axis3)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{axis0}{New position for axis 0}

\item{axis1}{New position for axis 1}

\item{axis2}{New position for axis 2}

\item{axis3}{New position for axis 3}
}
\value{
Permuted tensor
}
\description{
Permutes the tensor dimensions according to specified axes.
CRITICAL for attention mechanisms in transformers.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Create 4D tensor: (2, 3, 4, 5)
t <- ggml_new_tensor_4d(ctx, GGML_TYPE_F32, 2, 3, 4, 5)
# Swap axes 0 and 1: result shape (3, 2, 4, 5)
t_perm <- ggml_permute(ctx, t, 1, 0, 2, 3)
ggml_free(ctx)
}
}
