% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{ggml_opt_epoch}
\alias{ggml_opt_epoch}
\title{Run one training epoch}
\usage{
ggml_opt_epoch(
  opt_ctx,
  dataset,
  result_train = NULL,
  result_eval = NULL,
  idata_split,
  callback_train = TRUE,
  callback_eval = TRUE
)
}
\arguments{
\item{opt_ctx}{External pointer to optimizer context}

\item{dataset}{External pointer to dataset}

\item{result_train}{Result object to accumulate training stats (or NULL)}

\item{result_eval}{Result object to accumulate evaluation stats (or NULL)}

\item{idata_split}{Data index at which to split training and evaluation}

\item{callback_train}{Callback for training: TRUE for progress bar, FALSE for none,
or a function(train, ibatch, ibatch_max, t_start_us, result)}

\item{callback_eval}{Callback for evaluation: TRUE for progress bar, FALSE for none,
or a function(train, ibatch, ibatch_max, t_start_us, result)}
}
\value{
NULL invisibly
}
\description{
Performs training on the front portion of the dataset and evaluation
on the back portion. This gives more control than ggml_opt_fit.
}
\examples{
# Requires full optimizer setup - see ggml_opt_fit() for simpler API
if (FALSE) {
result_train <- ggml_opt_result_init()
result_eval <- ggml_opt_result_init()
ggml_opt_epoch(opt_ctx, dataset, result_train, result_eval,
               idata_split = 900, callback_train = TRUE)
ggml_opt_result_free(result_train)
ggml_opt_result_free(result_eval)
}
}
\seealso{
Other optimization: 
\code{\link{ggml_opt_alloc}()},
\code{\link{ggml_opt_context_optimizer_type}()},
\code{\link{ggml_opt_dataset_data}()},
\code{\link{ggml_opt_dataset_free}()},
\code{\link{ggml_opt_dataset_get_batch}()},
\code{\link{ggml_opt_dataset_init}()},
\code{\link{ggml_opt_dataset_labels}()},
\code{\link{ggml_opt_dataset_ndata}()},
\code{\link{ggml_opt_dataset_shuffle}()},
\code{\link{ggml_opt_default_params}()},
\code{\link{ggml_opt_eval}()},
\code{\link{ggml_opt_fit}()},
\code{\link{ggml_opt_free}()},
\code{\link{ggml_opt_grad_acc}()},
\code{\link{ggml_opt_init}()},
\code{\link{ggml_opt_inputs}()},
\code{\link{ggml_opt_labels}()},
\code{\link{ggml_opt_loss}()},
\code{\link{ggml_opt_loss_type_cross_entropy}()},
\code{\link{ggml_opt_loss_type_mean}()},
\code{\link{ggml_opt_loss_type_mse}()},
\code{\link{ggml_opt_loss_type_sum}()},
\code{\link{ggml_opt_ncorrect}()},
\code{\link{ggml_opt_optimizer_name}()},
\code{\link{ggml_opt_optimizer_type_adamw}()},
\code{\link{ggml_opt_optimizer_type_sgd}()},
\code{\link{ggml_opt_outputs}()},
\code{\link{ggml_opt_pred}()},
\code{\link{ggml_opt_prepare_alloc}()},
\code{\link{ggml_opt_reset}()},
\code{\link{ggml_opt_result_accuracy}()},
\code{\link{ggml_opt_result_free}()},
\code{\link{ggml_opt_result_init}()},
\code{\link{ggml_opt_result_loss}()},
\code{\link{ggml_opt_result_ndata}()},
\code{\link{ggml_opt_result_pred}()},
\code{\link{ggml_opt_result_reset}()},
\code{\link{ggml_opt_static_graphs}()}
}
\concept{optimization}
