% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_Rhat.R
\name{ggs_Rhat}
\alias{ggs_Rhat}
\title{Dotplot of Potential Scale Reduction Factor (Rhat)}
\usage{
ggs_Rhat(
  D,
  family = NA,
  scaling = 1.5,
  greek = FALSE,
  version_rhat = "BDA2",
  plot = TRUE
)
}
\arguments{
\item{D}{Data frame whith the simulations}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{scaling}{Value of the upper limit for the x-axis. By default, it is 1.5, to help contextualization of the convergence. When 0 or NA, the axis are not scaled.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}

\item{version_rhat}{Character variable with the name of the version of the potential scale reduction factor to use. Defaults to "BDA2", which refers to the second version of _Bayesian Data Analysis_ (Gelman, Carlin, Stern and Rubin). The other available version is "BG98", which refers to Brooks & Gelman (1998) and is the one used in the "coda" package.}

\item{plot}{Logical value indicating whether the plot must be returned (the default) or a tidy dataframe with the results of the Rhat diagnostics per Parameter.}
}
\value{
A \code{ggplot} object, or a \code{tidy} data frame.
}
\description{
Plot a dotplot of Potential Scale Reduction Factor (Rhat), proposed by Gelman and Rubin (1992). The version from the second edition of Bayesian Data Analysis (Gelman, Carlin, Stern and Rubin) is used, but the version used in the package "coda" can also be used (Brooks & Gelman 1998).
}
\details{
Notice that at least two chains are required.
}
\examples{
data(linear)
ggs_Rhat(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09

Gelman, Carlin, Stern and Rubin (2003) Bayesian Data Analysis. 2nd edition. Chapman & Hall/CRC, Boca Raton.

Gelman, A and Rubin, DB (1992) Inference from iterative simulation using multiple sequences, _Statistical Science_, *7*, 457-511.

Brooks, S. P., and Gelman, A. (1998). General methods for monitoring convergence of iterative simulations. _Journal of computational and graphical statistics_, 7(4), 434-455.
}
