% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_violin_interactive.R
\name{geom_violin_interactive}
\alias{geom_violin_interactive}
\title{Create interactive violin plot}
\usage{
geom_violin_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive violin plot -------
library(ggplot2)
library(ggiraph)

p <- ggplot(mtcars, aes(factor(cyl), mpg)) +
  geom_violin_interactive(aes(fill = cyl, tooltip = cyl))
x <- girafe(ggobj = p)
if( interactive() ) print(x)

# Show quartiles
p2 <- ggplot(mtcars, aes(factor(cyl), mpg)) +
  geom_violin_interactive(aes(tooltip=after_stat(density)),
                          draw_quantiles = c(0.25, 0.5, 0.75))
x2 <- girafe(ggobj = p2)
if( interactive() ) print(x2)
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
