% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipar.R
\name{interactive_parameters}
\alias{interactive_parameters}
\title{Interactive parameters}
\arguments{
\item{tooltip}{Tooltip text to associate with one or more elements.
If this is supplied a tooltip is shown when the element is hovered.
Plain text or html is supported.}

\item{onclick}{Javascript code to associate with one or more elements.
This code will be executed when the element is clicked.}

\item{hover_css}{Individual css style associate with one or more elements.
This css style is applied when the element is hovered and overrides the default style,
set via \code{\link{opts_hover}} or \code{\link{opts_hover_key}}.}

\item{selected_css}{Individual css style associate with one or more elements.
This css style is applied when the element is selected and overrides the default style,
set via \code{\link{opts_selection}} or \code{\link{opts_selection_key}}.}

\item{data_id}{Identifier to associate with one or more elements.
This is mandatory parameter if hover and selection interactivity is desired.
Identifiers are available as reactive input values in Shiny applications.}
}
\description{
Throughout ggiraph there are functions that add interactivity to ggplot plot elements.
The user can control the various aspects of interactivity by supplying
a special set of parameters to these functions.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
  \item As aesthetics with the mapping argument (via \code{\link[ggplot2]{aes}}).
  In this way they can be mapped to data columns and apply to a set of geometries.

  \item As plain arguments into the geom_*_interactive function (see
  \code{\link[ggplot2]{layer}}). In this way they can be set to a scalar value.
}
}

\section{Details for annotate_*_interactive functions}{

The interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors depending on params on base function.
}

\section{Details for scale_*_interactive and guide_*_interactive functions}{

For scales, the interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors, depending on the number of breaks (levels) and
the type of the guide used.
The guides do not accept any interactive parameter directly, they receive them from the scales.

\itemize{
  \item When guide of type `legend` is used, it will be converted to a
  \code{\link{guide_legend_interactive}} if it's not already.

  The length of each scale interactive parameter vector should match the length of the breaks.
  It can also be a named vector, where each name should correspond to the same break name.
  It can also be defined as function that takes the breaks as input and returns a named or
  unnamed vector of values as output.

  The interactive parameters here, give interactivity only to the key elements of the guide.

  \item When guide of type `colourbar` is used, it will be converted to a
  \code{\link{guide_colourbar_interactive}} if it's not already.

  The scale interactive parameters in this case should be scalar values and give interactivity
  to the colorbar only.
}

To provide interactivity to the rest of the elements of a guide, (title, labels, background, etc),
the relevant theme elements or relevant guide arguments can be used.
The \code{guide} arguments `title.theme` and `label.theme` can be defined as
\code{element_text_interactive} (in fact, they will be converted to that if they are not
already), either directly or via the theme.
See the element_*_interactive section for more details.
}

\section{Details for element_*_interactive functions}{

The interactive parameters can be supplied as arguments in the relevant function
and they should be scalar values.

For theme text elements (\code{\link{element_text_interactive}}), the interactive parameters
can also be supplied while setting a label value, via the \code{\link[ggplot2]{labs}} family
of functions or when setting a scale/guide title or key label.
Instead of setting a character value for the element, function
\code{\link{label_interactive}} can be used to define interactive parameters
to go along with the label.
When the parameters are supplied that way, they override the default values
that are set at the theme via \code{element_text_interactive} or via the \code{guide}'s
theme parameters.
}

\section{Details for interactive_*_grob functions}{

The interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors depending on params on base function.
}

\seealso{
\code{\link{girafe_options}}

\code{\link{girafe}}
}
