% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference.R
\name{as_reference}
\alias{as_reference}
\title{Create a reference to a layer for use in other filters}
\usage{
as_reference(x, id = NULL, include = is.null(id))
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{id}{A string identifying this layer for later use}

\item{include}{Should the layer itself be included in the graphic}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This function is basically synonymous with \code{with_raster()} but exist to make
the intend of marking a layer with a specific id clear.
}
\examples{
library(ggplot2)

ggplot() +
  as_reference(
    geom_point(aes(20, 300), size = 100, colour = 'white'),
    id = 'mask_layer'
  ) +
  with_mask(
    geom_point(aes(mpg, disp), mtcars, size = 5),
    mask = 'mask_layer'
  )


}
\seealso{
Other layer references: 
\code{\link{as_colourspace}()},
\code{\link{as_group}()}
}
\concept{layer references}
