% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/base_fortify_ts.R
\name{fortify.ts}
\alias{fortify.ts}
\title{Convert time-series-like to data.frame}
\usage{
\method{fortify}{ts}(model, data = NULL, columns = NULL, is.date = NULL,
  index.name = "Index", data.name = "Data", scale = FALSE, melt = FALSE,
  ...)
}
\arguments{
\item{model}{time-series-like instance}

\item{data}{original dataset, if needed}

\item{columns}{character vector specifies target column name(s)}

\item{is.date}{logical frag indicates whether the \code{stats::ts} is date or not
If not provided, regard the input as date when the frequency is 4 or 12}

\item{index.name}{specify column name for time series index}

\item{data.name}{specify column name for univariate time series data. Ignored in multivariate time series.}

\item{scale}{logical flag indicating whether to perform scaling each timeseries}

\item{melt}{logical flag indicating whether to melt each timeseries as variable}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert time-series-like to data.frame
}
\examples{
fortify(AirPassengers)
fortify(timeSeries::as.timeSeries(AirPassengers))
fortify(tseries::irts(cumsum(rexp(10, rate = 0.1)), matrix(rnorm(20), ncol=2)))
fortify(stats::stl(UKgas, s.window = 'periodic'))
fortify(stats::decompose(UKgas))
}

