% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/base_fortify_ts.R
\name{autoplot.ts}
\alias{autoplot.decomposed.ts}
\alias{autoplot.irts}
\alias{autoplot.stl}
\alias{autoplot.timeSeries}
\alias{autoplot.ts}
\alias{autoplot.xts}
\title{Autoplot time-series-like}
\usage{
\method{autoplot}{ts}(object, columns = NULL, group = NULL,
  is.date = NULL, index.name = "Index", p = NULL, ts.scale = FALSE,
  stacked = FALSE, facets = TRUE, nrow = NULL, ncol = 1,
  scales = "free_y", ts.geom = "line", ts.colour = NULL, ts.size = NULL,
  ts.linetype = NULL, ts.alpha = NULL, ts.fill = NULL, ts.shape = NULL,
  geom = ts.geom, colour = ts.colour, size = ts.size,
  linetype = ts.linetype, alpha = ts.alpha, fill = ts.fill,
  shape = ts.shape, xlim = c(NA, NA), ylim = c(NA, NA), log = "",
  main = NULL, xlab = "", ylab = "", asp = NULL, ...)
}
\arguments{
\item{object}{time-series-like instance}

\item{columns}{Character vector specifies target column name(s)}

\item{group}{Character vector specifies grouping}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not
If not provided, regard the input as date when the frequency is 4 or 12}

\item{index.name}{Specify column name for time series index when passing \code{data.frame} via data.}

\item{p}{\code{ggplot2::ggplot} instance}

\item{ts.scale}{Logical flag indicating whether to perform scaling each timeseries}

\item{stacked}{Logical flag indicating whether to stack multivariate timeseries}

\item{facets}{Logical value to specify use facets}

\item{nrow}{Number of facet/subplot rows}

\item{ncol}{Number of facet/subplot columns}

\item{scales}{Scale value passed to \code{ggplot2}}

\item{ts.geom}{geometric string for time-series. 'line', 'bar', 'ribbon', or 'point'}

\item{ts.colour}{line colour for time-series}

\item{ts.size}{point size for time-series}

\item{ts.linetype}{line type for time-series}

\item{ts.alpha}{alpha for time-series}

\item{ts.fill}{fill colour for time-series}

\item{ts.shape}{point shape for time-series}

\item{geom}{same as ts.geom}

\item{colour}{same as ts.colour}

\item{size}{same as ts.size}

\item{linetype}{same as ts.linetype}

\item{alpha}{same as ts.alpha}

\item{fill}{same as ts.fill}

\item{shape}{same as ts.shape}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot time-series-like
}
\examples{
data(Canada, package = 'vars')
autoplot(AirPassengers)
autoplot(UKgas, ts.geom = 'bar')
autoplot(Canada)
autoplot(Canada, facets = FALSE)

library(zoo)
autoplot(xts::as.xts(AirPassengers))
autoplot(timeSeries::as.timeSeries(AirPassengers))
its <- tseries::irts(cumsum(rexp(10, rate = 0.1)), matrix(rnorm(20), ncol=2))
autoplot(its)

autoplot(stats::stl(UKgas, s.window = 'periodic'))
autoplot(stats::decompose(UKgas))
}

