% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fortify_stats_lm.R
\name{autoplot.lm}
\alias{autoplot.lm}
\title{Autoplot \code{stats::lm} and \code{stats::glm}}
\usage{
\method{autoplot}{lm}(object, which = c(1:3, 5), data = NULL,
  colour = "#444444", size = NULL, linetype = NULL, alpha = NULL,
  fill = NULL, shape = NULL, label = TRUE, label.label = ".label",
  label.colour = "#000000", label.alpha = NULL, label.size = NULL,
  label.angle = NULL, label.family = NULL, label.fontface = NULL,
  label.lineheight = NULL, label.hjust = NULL, label.vjust = NULL,
  label.repel = FALSE, label.n = 3, smooth.colour = "#0000FF",
  smooth.linetype = "solid", ad.colour = "#888888",
  ad.linetype = "dashed", ad.size = 0.2, nrow = NULL, ncol = NULL, ...)
}
\arguments{
\item{object}{\code{stats::lm} instance}

\item{which}{If a subset of the plots is required, specify a subset of the numbers 1:6.}

\item{data}{original dataset, if needed}

\item{colour}{line colour}

\item{size}{point size}

\item{linetype}{line type}

\item{alpha}{alpha}

\item{fill}{fill colour}

\item{shape}{point shape}

\item{label}{Logical value whether to display labels}

\item{label.label}{Column name used for label text}

\item{label.colour}{Colour for text labels}

\item{label.alpha}{Alpha for text labels}

\item{label.size}{Size for text labels}

\item{label.angle}{Angle for text labels}

\item{label.family}{Font family for text labels}

\item{label.fontface}{Fontface for text labels}

\item{label.lineheight}{Lineheight for text labels}

\item{label.hjust}{Horizontal adjustment for text labels}

\item{label.vjust}{Vertical adjustment for text labels}

\item{label.repel}{Logical flag indicating whether to use \code{ggrepel}, enabling this may take some time for plotting}

\item{label.n}{Number of points to be laeled in each plot, starting with the most extreme}

\item{smooth.colour}{Line colour for smoother lines}

\item{smooth.linetype}{Line type for smoother lines}

\item{ad.colour}{Line colour for additional lines}

\item{ad.linetype}{Line type for additional lines}

\item{ad.size}{Fill colour for additional lines}

\item{nrow}{Number of facet/subplot rows}

\item{ncol}{Number of facet/subplot columns}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot \code{stats::lm} and \code{stats::glm}
}
\examples{
\dontrun{
autoplot(lm(Petal.Width ~ Petal.Length, data = iris))
autoplot(glm(Petal.Width ~ Petal.Length, data = iris), which = 1:6)
autoplot(lm(Petal.Width~Petal.Length, data = iris), data = iris, colour = 'Species')
}
}

