% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_contour}
\alias{gf_contour}
\title{Formula interface to geom_contour()}
\usage{
gf_contour(object = NULL, gformula = NULL, data = NULL, xlab, ylab,
  title, subtitle, caption, geom = "contour", stat = "contour",
  position = "identity", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{The geometric object to use display the data}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object
}
\description{
ggplot2 can not draw true 3d surfaces, but you can use \code{geom_contour}
and \code{\link[=geom_tile]{geom_tile()}} to visualise 3d surfaces in 2d. To be a valid
surface, the data must contain only a single row for each unique combination
of the variables mapped to the \code{x} and \code{y} aesthetics. Contouring
tends to work best when \code{x} and \code{y} form a (roughly) evenly
spaced grid. If your data is not evenly spaced, you may want to interpolate
to a grid before visualising.
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_density_2d(eruptions ~ waiting, data = faithful, alpha = 0.5, color = "navy") \%>\%
  gf_contour(density ~ waiting + eruptions, data = faithfuld, bins = 10, color = "red")
}
\seealso{
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}, \code{\link[=gf_density_2d]{gf_density_2d()}}
}
