% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_linerange}
\alias{gf_linerange}
\alias{gf_pointrange}
\title{Formula interface to geom_linerange() and geom_pointrange()}
\usage{
gf_linerange(object = NULL, gformula = NULL, data = NULL, alpha, color,
  group, linetype, size, xlab, ylab, title, subtitle, caption,
  geom = "linerange", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)

gf_pointrange(object = NULL, gformula = NULL, data = NULL, alpha, color,
  group, linetype, size, fatten = 2, xlab, ylab, title, subtitle, caption,
  geom = "pointrange", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{ymin + ymax ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{fatten}{A multiplicative factor used to increase the size of the
middle bar in \code{geom_crossbar()} and the middle point in
\code{geom_pointrange()}.}
}
\description{
Various ways of representing a vertical interval defined by \code{x},
\code{ymin} and \code{ymax}. Each case draws a single graphical object.
}
\examples{
gf_linerange()

if (require(mosaicData)) {
gf_ribbon(low_temp + high_temp ~ date, data = Weather,
          fill = ~ city, alpha = 0.4) \%>\%
   gf_theme(theme = theme_minimal())
gf_linerange(
  low_temp + high_temp ~ date | city ~ ., data = Weather,
  color = ~ ((low_temp + high_temp) / 2) ) \%>\%
  gf_refine(scale_colour_gradientn(colors = rev(rainbow(5)))) \%>\%
  gf_labs(color = "mid-temp")

gf_ribbon(low_temp + high_temp ~ date | city ~ ., data = Weather)

# Chaining in the data
Weather \%>\%
  gf_ribbon(low_temp + high_temp ~ date, alpha = 0.4) \%>\%
  gf_facet_grid(city ~ .)
}

if (require(mosaicData) && require(dplyr)) {
HELP2 <- HELPrct \%>\%
  group_by(substance, sex) \%>\%
  summarise(
    mean.age = mean(age),
    median.age = median(age),
    max.age = max(age),
    min.age = min(age),
    sd.age = sd(age),
    lo = mean.age - sd.age,
    hi = mean.age + sd.age
    )

  gf_jitter(age ~ substance, data = HELPrct,
      alpha = 0.5, width = 0.2, height = 0, color = "skyblue") \%>\%
    gf_pointrange( mean.age + lo + hi ~ substance,  data = HELP2) \%>\%
    gf_facet_grid( ~ sex)
  gf_jitter(age ~ substance, data = HELPrct,
      alpha = 0.5, width = 0.2, height = 0, color = "skyblue") \%>\%
    gf_errorbar( lo + hi ~ substance,  data = HELP2) \%>\%
    gf_facet_grid( ~ sex)
 # width is defined differently for gf_boxplot() and gf_jitter()
 #   * for gf_boxplot() it is the full width of the box.
 #   * for gf_jitter() it is half that -- the maximum amount added or subtracted.
 gf_boxplot(age ~ substance, data = HELPrct, width = 0.4) \%>\%
   gf_jitter(width = 0.4, height = 0, color = "skyblue", alpha = 0.5)
 gf_boxplot(age ~ substance, data = HELPrct, width = 0.4) \%>\%
   gf_jitter(width = 0.2, height = 0, color = "skyblue", alpha = 0.5)
}
}
\seealso{
\code{\link[ggplot2:geom_linerange]{ggplot2::geom_linerange()}}

\code{\link[ggplot2:geom_pointrange]{ggplot2::geom_pointrange()}}
}
