% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_function}
\alias{gf_function}
\alias{gf_fun}
\title{Layers displaying graphs of functions}
\usage{
gf_function(object = NULL, fun, data = NULL, ..., inherit = FALSE)

gf_fun(object = NULL, formula, data = NULL, ..., inherit = FALSE)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{fun}{A function.}

\item{data}{A data frame with the variables to be plotted.}

\item{...}{Additional arguments passed as \code{params} to \code{layer()}. This includes \code{xlim},
a numeric vector providing the extent of
the x-axis values used to evaluate \code{fun} for plotting. By default, \code{xlim} is not used for
other layers.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{formula}{A formula describing a function.  See examples and \code{\link[mosaicCore:makeFun]{mosaicCore::makeFun()}}.}
}
\description{
These functions provide two different
interfaces for creating a layer that contains the graph of a function.
}
\examples{
gf_function(fun = sqrt, xlim = c(0, 10))
gf_dhistogram(~age, data = mosaicData::HELPrct, binwidth = 3, alpha = 0.6) |>
  gf_function(
    fun = stats::dnorm,
    args = list(mean = mean(mosaicData::HELPrct$age), sd = sd(mosaicData::HELPrct$age)),
    color = "red"
  )
gf_fun(5 + 3 * cos(10 * x) ~ x, xlim = c(0, 2))
# Utility bill is quadratic in month?
f <- makeFun(lm(totalbill ~ poly(month, 2), data = mosaicData::Utilities))
gf_point(totalbill ~ month, data = mosaicData::Utilities, alpha = 0.6) |>
  gf_fun(f(m) ~ m, color = "red")
}
