% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{HCPC_tab}
\alias{HCPC_tab}
\title{Multiple Tables for Hierarchical Clusters}
\usage{
HCPC_tab(
  data,
  row_vars = character(),
  clust,
  wt,
  excl = character(),
  color = "diff",
  pct = "col",
  row_tot = "\% of population",
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{row_vars}{<\link[tidyr:tidyr_tidy_select]{tidy-select}> The row variables
of the table, to cross with the clusters. Typically, actives variables of the MCA.}

\item{clust}{In columns, the variable with the clusters, typically made with hierarchical
clustering functions like \code{\link[FactoMineR]{HCPC}} (object
`res$data.clust$clust`). Can be either a symbol or a character vector of
length 1 (for vars in `data`), or an external variable (not in `data`)
provided its length is equal to the number of rows of `data`.}

\item{wt}{The name of the weight variable. Leave empty for unweighted results.}

\item{excl}{The name of the levels to exclude, as a character vector.}

\item{color}{The type of colors to print, see \code{\link[tabxplor]{tab}}.}

\item{pct}{The type of percentages to print, see \code{\link[tabxplor]{tab}}.
Default to column percentages}

\item{row_tot}{The name of the total line (frequencies of each cluster)}

\item{...}{Additional arguments to pass to \code{\link[tabxplor]{tab_many}}.}
}
\value{
A \code{tibble} of class \code{tab}, possibly with colored reading helpers.
}
\description{
Multiple Tables for Hierarchical Clusters
}
\examples{

data(tea, package = "FactoMineR")
res.mca_3axes <- MCA2(tea, active_vars = 1:18, ncp = 3)
cah <- FactoMineR::HCPC(res.mca_3axes, nb.clust = 6, graph = FALSE)
tea$clust <- cah$data.clust$clust
HCPC_tab(tea, row_vars = all_of(names(tea)[1:18]), clust = "clust") #|>
#tabxplor::tab_kable()

}
