% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{MCA2}
\alias{MCA2}
\title{Multiple Correspondence Analysis}
\usage{
MCA2(data, active_vars, wt, excl, ncp = 5, graph = FALSE, ...)
}
\arguments{
\item{data}{The data frame.}

\item{active_vars}{<\link[tidyr:tidyr_tidy_select]{tidy-select}>}

\item{wt}{<\link[tidyr:tidyr_tidy_select]{tidy-select}>}

\item{excl}{A character vector of regular expressions to exclude "junk" categories.
Any level of an active variable with any of the detected patterns is not taken into
account in the calculation of axes (which is called specific multiple correspondence analysis).}

\item{ncp}{The number of axes to keep. Default to 5.}

\item{graph}{By default no graph is made, since the result can be ploted with
\code{\link{ggmca}}.}

\item{...}{Additionnal arguments to pass to \code{\link[FactoMineR]{MCA}}.}
}
\value{
A `res.mca` object, with all the data necessary to draw the MCA.
}
\description{
A user-friendly wrapper around \code{\link[FactoMineR]{MCA}}, made to
 work better with \pkg{ggfacto} functions like \code{\link{ggmca}}. All variables can
 be selected by many different expressions, in the way of the `tidyverse`.
 No supplementary vars are to be provided here, since they can be added afterward
 in \code{\link{ggmca}}.
}
\examples{
 data(tea, package = "FactoMineR")
res.mca <- MCA2(tea, active_vars = 1:18)

res.mca \%>\%
  ggmca(tea, sup_vars = c("SPC"), ylim = c(NA, 1.2), text_repel = TRUE) \%>\%
  ggi() #to make the graph interactive
}
