% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{pers_or_plot}
\alias{pers_or_plot}
\title{Modified odd ratios plot from `finalfit`}
\usage{
pers_or_plot(
  .data,
  dependent,
  explanatory,
  random_effect = NULL,
  factorlist = NULL,
  glmfit = NULL,
  confint_type = NULL,
  remove_ref = FALSE,
  break_scale = NULL,
  column_space = c(-0.5, 0, 0.2),
  dependent_label = NULL,
  prefix = "",
  suffix = ": OR (95\% CI, p-value)",
  table_text_size = 5,
  title_text_size = 18,
  plot_opts = NULL,
  table_opts = NULL,
  return_df = FALSE,
  ...
)
}
\arguments{
\item{.data}{Data frame.}

\item{dependent}{Character vector of length 1: name of dependent variable
(must have 2 levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory variables.}

\item{random_effect}{Character vector of length 1, name of random effect variable.}

\item{factorlist}{Option to provide output directly from \code{summary_factorlist()}.}

\item{glmfit}{Option to provide output directly from \code{glmmulti()} and \code{glmmixed()}.}

\item{confint_type}{One of \code{c("profile", "default")} for GLM models or
\code{c("default", "Wald", "profile", "boot")} for \code{glmer models}.
Note \code{"default" == "Wald"}.}

\item{remove_ref}{Logical. Remove reference level for factors.}

\item{break_scale}{Manually specify x-axis breaks in format \code{c(0.1, 1, 10)}.}

\item{column_space}{Adjust table column spacing.}

\item{dependent_label}{Main label for plot.}

\item{prefix}{Plots are titled by default with the dependent variable. This adds
text before that label.}

\item{suffix}{Plots are titled with the dependent variable. This adds text after
that label.}

\item{table_text_size}{Alter font size of table text.}

\item{title_text_size}{Alter font size of title text.}

\item{plot_opts}{A list of arguments to be appended to the ggplot call by \code{"+"}.}

\item{table_opts}{A list of arguments to be appended to the ggplot table call by
\code{"+"}.}

\item{return_df}{To return the dataframe.}

\item{...}{Other parameters.}
}
\value{
The odd ratios plot as a \code{ggplot2} object.
}
\description{
Modified odd ratios plot from `finalfit`
}
