% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotPath}
\alias{plotPath}
\title{Construct the graphic object of the path}
\usage{
plotPath(path, geneal, colName, colNameY = "", fontFace = 1)
}
\arguments{
\item{path}{object created from function getPath}

\item{geneal}{the full genealogy  (in data frame format)}

\item{colName}{the name of the column of the data frame that contains the quantitative variable of interest (in character string format)}

\item{colNameY}{the name of the second optional column of the data frame that contains the second optional quantitative variable of interest (in character string format). This optional quantitative variable will be plotted on the vertical axis.}

\item{fontFace}{fontface for the two nodes of interest (1=plain, 2=bold, 3=italic, 4=bold-italic), DEFAULT is 1}
}
\description{
This function takes the path as input and outputs an ggplot2 object. The
image will correctly position the node labels with x-axis representing the node
date, and y-axis representing the node path index. Edges between two nodes represent
parent-child relationships between those nodes. For visual appeal, there is a grey
box that outlines the node label, as well as an underline and overline for each label.
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
pathTN <- getPath("Tokyo", "Narow", sbIG, sbGeneal, "devYear")
plotPath(pathTN, sbGeneal, "devYear")

sbFilt <- sbGeneal[complete.cases(sbGeneal[1:3]),]
sbFiltIG <- dfToIG(sbFilt)
pathCL <- getPath("Clark", "Lawrence", sbFiltIG, sbFilt, "yield")
plotPath(pathCL, sbFilt, "devYear", "yield") + ggplot2::xlab("Dev Year") + ggplot2::ylab("Yield")
}
\seealso{
\code{\link{getPath}} for information on input path building
}
