% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{n1PDF_plba0_gpu}
\alias{n1PDF_plba0_gpu}
\alias{n1PDF_plba1_gpu}
\title{A Rcpp connection to the GPU-based PLBA n1PDF type 0 and type 1}
\usage{
n1PDF_plba0_gpu(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread,
  gpuid, bw, debug)

n1PDF_plba1_gpu(x, A, b, mean_v, sd_v, t0, mean_w, rD, swt, n, nthread,
  gpuid, bw, debug)
}
\arguments{
\item{x}{response time vector}

\item{A}{start point variability}

\item{b}{threshold}

\item{mean_v}{mean drift rate vector for the first piece of evidence
accumulation.}

\item{sd_v}{standard deviation of the drift rates}

\item{t0}{nondecision time}

\item{mean_w}{mean drift rate vector for the second piece of evidence
accumulation.}

\item{rD}{rate delay time (s)}

\item{swt}{switch time (s)}

\item{n}{number of simulations}

\item{nthread}{thread number to launch in GPU}

\item{gpuid}{which gpu card to use, starting from 0.}

\item{bw}{kernel bandwidth}

\item{debug}{debugging?}
}
\description{
This is an Rcpp function calling a \code{n1PDF_plba0_gpu} function defined
in the global environment, which connect to an interanl ppda simulated-based
PLBA density function.
}
