% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_model.R
\name{print_cell_p}
\alias{print_cell_p}
\title{Print accumulator x internal parameter type matrix for each cell}
\usage{
print_cell_p(p.vector, model)
}
\arguments{
\item{p.vector}{a parameter vector,}

\item{model}{a DMC model}
}
\description{
A DMC model array, created by \code{model.dmc} is computationally efficient
but it is not easy to see how parameters map to design cells.
\code{print.cell.p} makes it easy to loop through cells and print the
mapping.
}
\examples{
model <- model.dmc(
p.map     = list(A = "1", B = "1", mean_v = "M", sd_v = "M", t0 = "1",
                 st0 = "1"),
match.map = list(M = list(s1 = 1, s2 = 2)),
factors   = list(S = c("s1", "s2")),
constants = c(st0 = 0, sd_v.false=1),
responses = c("r1","r2"),
type      = "norm")
p.vector <- c(A=3, B=4, mean_v.true=2, mean_v.false=-1, sd_v.true=0.5, t0=.2)
print_cell_p(p.vector, model)
}

