% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_plotting.R
\name{plot.dmc}
\alias{plot.dmc}
\title{Plot DMC Samples}
\usage{
\method{plot}{dmc}(x, y = NULL, start = 1, end = NA, save.ll = FALSE,
  main.pll = NULL, pll.chain = FALSE, pll.together = TRUE,
  pll.barplot = FALSE, only.prior = FALSE, only.like = FALSE,
  smooth = FALSE, density = FALSE, save.dat = FALSE, p.prior = NULL,
  natural = TRUE, trans = NA, xlim = NA, chain1 = TRUE, ...)
}
\arguments{
\item{x}{a \code{run.dmc} or \code{samples.dmc} generated model samples}

\item{y}{default NULL. No function. Just to make it compatible to
\code{plot}}

\item{start}{instruct the function to plot starting from which iteration.
This indicates how many burn-in interations one requests. For example,
start=101, indicates 100 burn-in interations.}

\item{end}{instruct the function to plot ending at a certain iteration}

\item{save.ll}{a boolean switch to tell the function to save the mean
log-likelihood. This option does not work in DMC's plot.dmc, too.}

\item{main.pll}{a string as the title for the boxplot. Default is NULL}

\item{pll.chain}{a boolean switch to plot posterior log likelihoood}

\item{pll.together}{a boolean switch to plot the posterior log-likelihood
chains all together in one canvar}

\item{pll.barplot}{a boolean switch to plot the means of posterior
log-likelihood of all chains as a barplot. By default, it is off.}

\item{only.prior}{Default is FALSE}

\item{only.like}{Default is FALSE. only.prior and only.like two switches
to plot only prior density or only log-likelihood probability.}

\item{smooth}{default FALSE}

\item{density}{plot probability density together with trace? Default FALSE}

\item{save.dat}{whether save the internal data table out for polish plots}

\item{p.prior}{prior distribution setting. necessary for plot.prior to work}

\item{natural}{additional argument for plot.prior}

\item{trans}{additional argument for plot.prior}

\item{xlim}{additional argument for plot.prior}

\item{chain1}{plot all chains or just chain1}

\item{...}{other arguments}
}
\description{
Plot trace and probability desntiy, using a model samples.
}
\details{
If a samples with hyper attribute is set, plot.hyper will be called.
If pll.chain=TRUE changes samples$pll to an mcmc object and plots
posterior log-likelihood of chains.
}
\examples{
m1 <- model.dmc(
  p.map=list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
  constants=c(st0=0,d=0),
  match.map=list(M=list(s1="r1",s2="r2")),
  factors=list(S=c("s1","s2")),
  responses=c("r1","r2"),
  type="rd")

p.vector <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)

dat1 <- simulate(m1, nsim=1e2, p.vector=p.vector)
mdi1 <- data.model.dmc(dat1, m1)

p.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1=c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2=c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower=c(0,-5, 0, 0, 0, 0),
  upper=c(5, 7, 2, 2, 2, 2))

samples0 <- samples.dmc(nmc=100, p.prior=p.prior, data=mdi1)
samples0 <- run.dmc(samples0, p.migrate=.05)

## Windows tests produce grid.Call problems
## Use should use with caution.
## plot(samples0)
## plot(samples0, density=TRUE)
## plot(samples0, start=101)
## plot(samples0, start=101, density=TRUE)
## plot(samples0, pll.chain=TRUE)
}
\keyword{plot.dmc}

