% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_analysis.R
\name{summary.dmc.list}
\alias{summary.dmc.list}
\title{Summarise a DMC Sample with Multiple Participants}
\usage{
\method{summary}{dmc.list}(object, digits = 2, start = 1, end = NA, ...)
}
\arguments{
\item{object}{a model samples}

\item{digits}{how many digits to print}

\item{start}{summarise from which MCMC iteration. Default uses the first
iteration.}

\item{end}{summarise to the end of MCMC iteration. For example, set
\code{start=101} and \code{end=1000}, instructs the function to calculate
from 101 to 1000 iteration.  Default uses the last iteration.}

\item{...}{other aruguments}
}
\description{
Call coda package to summarise the model parameters in a DMC samples with
multiple participants
}
\examples{
m1 <- model.dmc(
      p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1",t0="1",
                       st0="1"),
      match.map = list(M=list(s1="r1",s2="r2")),
      factors   = list(S=c("s1","s2"),F=c("f1","f2")),
      constants = c(st0=0,d=0),
      responses = c("r1","r2"),
      type      = "rd")

pop.mean  <- c(a=1.15, v.f1=1.25, v.f2=1.85, z=0.55, sz=0.15, sv=0.32,
               t0=0.25)
pop.scale <- c(a=0.10, v.f1=.8,   v.f2=.5,   z=0.1,  sz=0.05, sv=0.05,
               t0=0.05)
pop.prior <- prior.p.dmc(
  dists = rep("tnorm", length(pop.mean)),
  p1    = pop.mean,
  p2    = pop.scale,
  lower = c(0,-5, -5, 0, 0,   0, 0),
  upper = c(5, 7,  7, 1, 0.5, 2, 2))

dat  <- h.simulate.dmc(m1, nsim=30, ns=4, p.prior=pop.prior)
mdi1 <- data.model.dmc(dat, m1)
ps   <- attr(dat,  "parameters")

p.prior <- prior.p.dmc(
  dists= rep("tnorm", length(pop.mean)),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))
samples0 <- h.samples.dmc(nmc=30, p.prior=p.prior, data=mdi1, thin=1)
samples0 <- h.run.dmc(samples0)
class(samples0)
## [1] "dmc.list"
gelman.diag.dmc(samples0)

## summary calls theta.as.mcmc.list, which is very slow.
## summary(samples0)
}
\seealso{
\code{\link{summary.dmc}, \link{summary.hyper}}
}
\keyword{summary}

