% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_analysis.R
\name{effectiveSize.dmc}
\alias{effectiveSize.dmc}
\title{Effective Sample Size for Estimating the Mean}
\usage{
effectiveSize.dmc(x, hyper = FALSE, digits = 0, start = 1, end = NA)
}
\arguments{
\item{x}{a DMC sample}

\item{hyper}{a switch to extract hyper attribute and calculate it}

\item{digits}{print out how many digits}

\item{start}{start iteration}

\item{end}{end iteraton}
}
\description{
\code{effectiveSize.dmc} calls \pkg{coda} effectiveSize to effective size
for either single or multiple subjects. It can calculate at the data or
hyper level, too.
}
\examples{
m1 <- model.dmc(
     p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
     match.map = list(M=list(s1="r1",s2="r2")),
     factors   = list(S=c("s1","s2"),F=c("f1","f2")),
     constants = c(st0=0,d=0),
     responses = c("r1","r2"),
     type      = "rd")

pop.mean  <- c(a=1.15, v.f1=1.25, v.f2=1.85, z=.55,  sz=.15, sv=.32, t0=.25)
pop.scale <- c(a=.10,  v.f1=.8,   v.f2=.5,   z=0.1,  sz=.05, sv=.05, t0=.05)
pop.prior <- prior.p.dmc(
  dists = rep("tnorm", length(pop.mean)),
  p1    = pop.mean,
  p2    = pop.scale,
  lower = c(0,-5, -5, 0, 0,   0, 0),
  upper = c(5, 7,  7, 1, 0.5, 2, 2))

dat  <- h.simulate.dmc(m1, nsim=30, ns=4, p.prior=pop.prior)
mdi1 <- data.model.dmc(dat, m1)
ps   <- attr(dat,  "parameters")
### FIT RANDOM EFFECTS
p.prior <- prior.p.dmc(
  dists = c("tnorm","tnorm","tnorm","tnorm","tnorm", "tnorm", "tnorm"),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))

mu.prior <- prior.p.dmc(
  dists = c("tnorm","tnorm","tnorm","tnorm","tnorm", "tnorm", "tnorm"),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))

sigma.prior <- prior.p.dmc(
  dists = rep("beta", length(p.prior)),
  p1=c(a=1, v.f1=1,v.f2 = 1, z=1, sz=1, sv=1, t0=1),p2=c(1,1,1,1,1,1,1),
  upper=c(2,2,2,2,2, 2, 2))

pp.prior <- list(mu.prior, sigma.prior)

hsamples0 <- h.samples.dmc(nmc=10, p.prior=p.prior, pp.prior=pp.prior,
  data=mdi1, thin=1)
hsamples0 <- h.run.dmc(hsamples0)
es <- effectiveSize.dmc(hsamples0)
hes <- effectiveSize.dmc(hsamples0, hyper=TRUE)
}

