% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{dmode}
\alias{dmode}
\title{Mode from density estimation}
\usage{
dmode(x, adjust = 1.5)
}
\arguments{
\item{x}{Value vector. Numeric or integers.}

\item{adjust}{Bandwidth adjustment. See \link{density}.}
}
\description{
Finds the mode using the \link{density} function and then obtains the maximum value.
}
\examples{
x <- rchisq(1000, 3)
hist(x, br=50)
abline(v = dmode(x), col = "red")
abline(v = median(x), col = "green")
abline(v = mean(x), col = "blue")
}
