% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_spike.R
\name{stat_spike}
\alias{stat_spike}
\title{Spike plot (ggplot2 stat)}
\usage{
stat_spike(
  mapping = NULL,
  data = NULL,
  geom = "spike",
  position = "identity",
  ...,
  at = "median",
  p_limits = c(NA, NA),
  density = "bounded",
  adjust = waiver(),
  trim = TRUE,
  expand = FALSE,
  breaks = waiver(),
  align = "none",
  outline_bars = FALSE,
  slab_type = NULL,
  limits = NULL,
  n = 501,
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between \code{\link[=stat_spike]{stat_spike()}} and \code{\link[=geom_spike]{geom_spike()}}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[=position_dodge]{position_dodge()}}) or \code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if
you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat. When paired with the default geom, \code{\link[=geom_spike]{geom_spike()}},
these include:
\describe{
\item{\code{normalize}}{How to normalize heights of functions input to the \code{thickness} aesthetic. One of:
\itemize{
\item \code{"all"}: normalize so that the maximum height across all data is \code{1}.
\item \code{"panels"}: normalize within panels so that the maximum height in each panel is \code{1}.
\item \code{"xy"}: normalize within the x/y axis opposite the \code{orientation} of this geom so
that the maximum height at each value of the opposite axis is \code{1}.
\item \code{"groups"}: normalize within values of the opposite axis and within each
group so that the maximum height in each group is \code{1}.
\item \code{"none"}: values are taken as is with no normalization (this should probably
only be used with functions whose values are in [0,1], such as CDFs).
}
For a comprehensive discussion and examples of slab scaling and normalization, see the
\href{https://mjskay.github.io/ggdist/articles/thickness.html}{\code{thickness} scale article}.}
\item{\code{arrow}}{\code{\link[grid:arrow]{grid::arrow()}} giving the arrow heads to use on the spike, or \code{NULL} for no arrows.}
\item{\code{subguide}}{Sub-guide used to annotate the \code{thickness} scale. One of:
\itemize{
\item A function that takes a \code{scale} argument giving a \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale}
object and an \code{orientation} argument giving the orientation of the
geometry and then returns a \link[grid:grid.grob]{grid::grob} that will draw the axis
annotation, such as \code{\link[=subguide_axis]{subguide_axis()}} (to draw a traditional axis) or
\code{\link[=subguide_none]{subguide_none()}} (to draw no annotation). See \code{\link[=subguide_axis]{subguide_axis()}}
for a list of possibilities and examples.
\item A string giving the name of such a function when prefixed
with \code{"subguide"}; e.g. \code{"axis"} or \code{"none"}.
}}
}}

\item{at}{The points at which to evaluate the PDF and CDF of the distribution. One of:
\itemize{
\item \link{numeric} vector: points to evaluate the PDF and CDF of the distributions at.
\item function or character vector: function (or names of functions) which,
when applied on a distribution-like object (e.g. a \pkg{distributional} object or a
\code{\link[posterior:rvar]{posterior::rvar()}}), returns a vector of values to evaluate the distribution functions at.
\item a \link{list} where each element is any of the above (e.g. a \link{numeric}, function, or
name of a function): the evaluation points determined by each element of the
list are concatenated together. This means, e.g., \code{c(0, median, qi)} would add
a spike at \code{0}, the median, and the endpoints of the \code{qi} of the distribution.
}

The values of \code{at} are also converted into a character vector which is supplied
as a computed variable (also called \code{at}) generated by this \code{stat}, which can be
mapped onto aesthetics using \code{\link[=after_stat]{after_stat()}}. Non-empty names can be used to override
the values of the computed variable; e.g. \code{at = c(zero = 0, "median", mode = "Mode")}
will generate a computed variable with the values \code{c("zero", "median", "mode")} that
is evaluated at \code{0}, the median, and the mode of the distribution.}

\item{p_limits}{Probability limits (as a vector of size 2) used to determine the lower and upper
limits of \emph{theoretical} distributions (distributions from \emph{samples} ignore this parameter and determine
their limits based on the limits of the sample). E.g., if this is \code{c(.001, .999)}, then a slab is drawn
for the distribution from the quantile at \code{p = .001} to the quantile at \code{p = .999}. If the lower
(respectively upper) limit is \code{NA}, then the lower (upper) limit will be the minimum (maximum) of the
distribution's support if it is finite, and \code{0.001} (\code{0.999}) if it is not finite. E.g., if
\code{p_limits} is \code{c(NA, NA)}, on a gamma distribution the effective value of \code{p_limits} would be
\code{c(0, .999)} since the gamma distribution is defined on \verb{(0, Inf)}; whereas on a normal distribution
it would be equivalent to \code{c(.001, .999)} since the normal distribution is defined on \verb{(-Inf, Inf)}.}

\item{density}{Density estimator for sample data. One of:
\itemize{
\item A function which takes a numeric vector and returns a list with elements
\code{x} (giving grid points for the density estimator) and \code{y} (the
corresponding densities). \pkg{ggdist} provides a family of functions
following this format, including \code{\link[=density_unbounded]{density_unbounded()}} and
\code{\link[=density_bounded]{density_bounded()}}. This format is also compatible with \code{\link[stats:density]{stats::density()}}.
\item A string giving the suffix of a function name that starts with \code{"density_"};
e.g. \code{"bounded"} for \verb{[density_bounded()]}, \code{"unbounded"} for \verb{[density_unbounded()]},
or \code{"histogram"} for \code{\link[=density_histogram]{density_histogram()}}.
Defaults to \code{"bounded"}, i.e. \code{\link[=density_bounded]{density_bounded()}}, which estimates the bounds from
the data and then uses a bounded density estimator based on the reflection method.
}}

\item{adjust}{Passed to \code{density}: the bandwidth for the density estimator for sample data
is adjusted by multiplying it by this value. See e.g. \code{\link[=density_bounded]{density_bounded()}} for more information.
Default (\code{waiver()}) defers to the default of the density estimator, which is usually \code{1}.}

\item{trim}{For sample data, should the density estimate be trimmed to the range of the
data? Passed on to the density estimator; see the \code{density} parameter. Default \code{TRUE}.}

\item{expand}{For sample data, should the slab be expanded to the limits of the scale? Default \code{FALSE}.
Can be length two to control expansion to the lower and upper limit respectively.}

\item{breaks}{Determines the breakpoints defining bins. Defaults to \code{"Scott"}.
Similar to (but not exactly the same as) the \code{breaks} argument to \code{\link[graphics:hist]{graphics::hist()}}.
One of:
\itemize{
\item A scalar (length-1) numeric giving the number of bins
\item A vector numeric giving the breakpoints between histogram bins
\item A function taking \code{x} and \code{weights} and returning either the
number of bins or a vector of breakpoints
\item A string giving the suffix of a function that starts with
\code{"breaks_"}. \pkg{ggdist} provides weighted implementations of the
\code{"Sturges"}, \code{"Scott"}, and \code{"FD"} break-finding algorithms from
\code{\link[graphics:hist]{graphics::hist()}}, as well as \code{\link[=breaks_fixed]{breaks_fixed()}} for manually setting
the bin width. See \link{breaks}.
}

For example, \code{breaks = "Sturges"} will use the \code{\link[=breaks_Sturges]{breaks_Sturges()}} algorithm,
\code{breaks = 9} will create 9 bins, and \code{breaks = breaks_fixed(width = 1)} will
set the bin width to \code{1}.}

\item{align}{Determines how to align the breakpoints defining bins. Default
(\code{"none"}) performs no alignment. One of:
\itemize{
\item A scalar (length-1) numeric giving an offset that is subtracted from the breaks.
The offset must be between \code{0} and the bin width.
\item A function taking a sorted vector of \code{breaks} (bin edges) and returning
an offset to subtract from the breaks.
\item A string giving the suffix of a function that starts with
\code{"align_"} used to determine the alignment, such as \code{\link[=align_none]{align_none()}},
\code{\link[=align_boundary]{align_boundary()}}, or \code{\link[=align_center]{align_center()}}.
}

For example, \code{align = "none"} will provide no alignment, \code{align = align_center(at = 0)}
will center a bin on \code{0}, and \code{align = align_boundary(at = 0)} will align a bin
edge on \code{0}.}

\item{outline_bars}{For sample data (if \code{density} is \code{"histogram"}) and for discrete analytical
distributions (whose slabs are drawn as histograms), determines
if outlines in between the bars are drawn when the \code{slab_color} aesthetic is used. If \code{FALSE}
(the default), the outline is drawn only along the tops of the bars; if \code{TRUE}, outlines in between
bars are also drawn. See \code{\link[=density_histogram]{density_histogram()}}.}

\item{slab_type}{(deprecated) The type of slab function to calculate: probability density (or mass) function
(\code{"pdf"}), cumulative distribution function (\code{"cdf"}), or complementary CDF (\code{"ccdf"}). Instead of using
\code{slab_type} to change \code{f} and then mapping \code{f} onto an aesthetic, it is now recommended to simply map the
corresponding computed variable (e.g. \code{pdf}, \code{cdf}, or  \code{1 - cdf}) directly onto the desired aesthetic.}

\item{limits}{Manually-specified limits for the slab, as a vector of length two. These limits are combined with those
computed based on \code{p_limits} as well as the limits defined by the scales of the plot to determine the
limits used to draw the slab functions: these limits specify the maximal limits; i.e., if specified, the limits
will not be wider than these (but may be narrower). Use \code{NA} to leave a limit alone; e.g.
\code{limits = c(0, NA)} will ensure that the lower limit does not go below 0, but let the upper limit
be determined by either \code{p_limits} or the scale settings.}

\item{n}{Number of points at which to evaluate the function that defines the slab.}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a spike geometry which can be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Stat for drawing "spikes" (optionally with points on them) at specific points
on a distribution (numerical or determined as a function of the distribution),
intended for annotating \code{\link[=stat_slabinterval]{stat_slabinterval()}} geometries.
}
\details{
This stat computes slab values (i.e. PDF and CDF values) at specified locations
on a distribution, as determined by the \code{at} parameter.

\strong{To visualize sample data}, such as a data distribution, samples from a
bootstrap distribution, or a Bayesian posterior, you can supply samples to
the \code{x} or \code{y} aesthetic.

\strong{To visualize analytical distributions}, you can use the \code{xdist} or \code{ydist}
aesthetic. For historical reasons, you can also use \code{dist} to specify the distribution, though
this is not recommended as it does not work as well with orientation detection.
These aesthetics can be used as follows:
\itemize{
\item \code{xdist}, \code{ydist}, and \code{dist} can be any distribution object from the \href{https://pkg.mitchelloharawild.com/distributional/}{distributional}
package (\code{\link[=dist_normal]{dist_normal()}}, \code{\link[=dist_beta]{dist_beta()}}, etc) or can be a \code{\link[posterior:rvar]{posterior::rvar()}} object.
Since these functions are vectorized,
other columns can be passed directly to them in an \code{\link[=aes]{aes()}} specification; e.g.
\code{aes(dist = dist_normal(mu, sigma))} will work if \code{mu} and \code{sigma} are columns in the
input data frame.
\item \code{dist} can be a character vector giving the distribution name. Then the  \code{arg1}, ... \code{arg9}
aesthetics (or \code{args} as a list column) specify distribution arguments. Distribution names
should correspond to R functions that have \code{"p"}, \code{"q"}, and \code{"d"} functions; e.g. \code{"norm"}
is a valid distribution name because R defines the \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, and \code{\link[=dnorm]{dnorm()}}
functions for Normal distributions.

See the \code{\link[=parse_dist]{parse_dist()}} function for a useful way to generate \code{dist} and \code{args}
values from human-readable distribution specs (like \code{"normal(0,1)"}). Such specs are also
produced by other packages (like the \code{brms::get_prior} function in brms); thus,
\code{\link[=parse_dist]{parse_dist()}} combined with the stats described here can help you visualize the output
of those functions.
}
}
\section{Aesthetics}{

The spike \code{geom} has a wide variety of aesthetics that control
the appearance of its two sub-geometries: the \strong{spike} and the \strong{point}.

These \code{stat}s support the following aesthetics:

\itemize{
\item{\code{x}: x position of the geometry (when orientation = \code{"vertical"}); or sample data to be summarized
(when \code{orientation = "horizontal"} with sample data).}
\item{\code{y}: y position of the geometry (when orientation = \code{"horizontal"}); or sample data to be summarized
(when \code{orientation = "vertical"} with sample data).}
\item{\code{weight}: When using samples (i.e. the \code{x} and \code{y} aesthetics, not \code{xdist} or \code{ydist}), optional
weights to be applied to each draw.}
\item{\code{xdist}: When using analytical distributions, distribution to map on the x axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{ydist}: When using analytical distributions, distribution to map on the y axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{dist}: When using analytical distributions, a name of a distribution (e.g. \code{"norm"}), a
\pkg{distributional} object (e.g. \code{\link[=dist_normal]{dist_normal()}}), or a \code{\link[posterior:rvar]{posterior::rvar()}} object. See \strong{Details}.}
\item{\code{args}: Distribution arguments (\code{args} or \code{arg1}, ... \code{arg9}). See \strong{Details}.}
}

In addition, in their default configuration (paired with \code{\link[=geom_spike]{geom_spike()}})
the following aesthetics are supported by the underlying geom:

\strong{Spike-specific (aka Slab-specific) aesthetics}

\itemize{
\item{\code{thickness}: The thickness of the slab at each \code{x} value (if \code{orientation = "horizontal"}) or
\code{y} value (if \code{orientation = "vertical"}) of the slab.}
\item{\code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}
\item{\code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space
between adjacent slabs. For a comprehensive discussion and examples of slab scaling and normalization,
see the \href{https://mjskay.github.io/ggdist/articles/thickness.html}{\code{thickness} scale article}.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{spike} and \strong{point} sub-geometries.}
\item{\code{fill}: The fill color of the \strong{point} sub-geometry.}
\item{\code{alpha}: The opacity of the \strong{spike} and \strong{point} sub-geometries.}
\item{\code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{\link[=scale_colour_ramp]{scale_colour_ramp()}} for examples.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of the line used to draw the \strong{spike} sub-geometry.}
\item{\code{size}: Size of the \strong{point} sub-geometry.}
\item{\code{stroke}: Width of the outline around the \strong{point} sub-geometry.}
\item{\code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{spike}.}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{width}}
\item{\code{height}}
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\section{Computed Variables}{

The following variables are computed by this stat and made available for
use in aesthetic specifications (\code{\link[=aes]{aes()}}) using the \code{\link[=after_stat]{after_stat()}}
function or the \code{after_stat} argument of \code{\link[=stage]{stage()}}:
\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{.width}: For intervals, the interval width as a numeric value in \verb{[0, 1]}.
For slabs, the width of the smallest interval containing that value of the slab.
\item \code{level}: For intervals, the interval width as an ordered factor.
For slabs, the level of the smallest interval containing that value of the slab.
\item \code{pdf}: For slabs, the probability density function (PDF).
If \code{options("ggdist.experimental.slab_data_in_intervals")} is \code{TRUE}:
For intervals, the PDF at the point summary; intervals also have \code{pdf_min} and \code{pdf_max}
for the PDF at the lower and upper ends of the interval.
\item \code{cdf}: For slabs, the cumulative distribution function.
If \code{options("ggdist.experimental.slab_data_in_intervals")} is \code{TRUE}:
For intervals, the CDF at the point summary; intervals also have \code{cdf_min} and \code{cdf_max}
for the CDF at the lower and upper ends of the interval.
\item \code{n}: For slabs, the number of data points summarized into that slab. If the slab was created from
an analytical distribution via the \code{xdist}, \code{ydist}, or \code{dist} aesthetic, \code{n} will be \code{Inf}.
\item \code{f}: (deprecated) For slabs, the output values from the slab function (such as the PDF, CDF, or CCDF),
determined by \code{slab_type}. Instead of using \code{slab_type} to change \code{f} and then mapping \code{f} onto an
aesthetic, it is now recommended to simply map the corresponding computed variable (e.g. \code{pdf}, \code{cdf}, or
\code{1 - cdf}) directly onto the desired aesthetic.
\item \code{at}: For spikes, a character vector of names of the functions or expressions used to determine
the points at which the slab functions were evaluated to create spikes. Values of this computed
variable are determined by the \code{at} parameter; see its description above.
}
}

\examples{
library(ggplot2)
library(distributional)
library(dplyr)

df = tibble(
  d = c(dist_normal(1), dist_gamma(2,2)), g = c("a", "b")
)

# annotate the density at the mode of a distribution
df \%>\%
  ggplot(aes(y = g, xdist = d)) +
  stat_slab(aes(xdist = d)) +
  stat_spike(at = "Mode") +
  # need shared thickness scale so that stat_slab and geom_spike line up
  scale_thickness_shared()

# annotate the endpoints of intervals of a distribution
# here we'll use an arrow instead of a point by setting size = 0
arrow_spec = arrow(angle = 45, type = "closed", length = unit(4, "pt"))
df \%>\%
  ggplot(aes(y = g, xdist = d)) +
  stat_halfeye(point_interval = mode_hdci) +
  stat_spike(
    at = function(x) hdci(x, .width = .66),
    size = 0, arrow = arrow_spec, color = "blue", linewidth = 0.75
  ) +
  scale_thickness_shared()

# annotate quantiles of a sample
set.seed(1234)
data.frame(x = rnorm(1000, 1:2), g = c("a","b")) \%>\%
  ggplot(aes(x, g)) +
  stat_slab() +
  stat_spike(at = function(x) quantile(x, ppoints(10))) +
  scale_thickness_shared()

}
\seealso{
See \code{\link[=geom_spike]{geom_spike()}} for the geom underlying this stat.
See \code{\link[=stat_slabinterval]{stat_slabinterval()}} for the stat this shortcut is based on.

Other slabinterval stats: 
\code{\link{stat_ccdfinterval}()},
\code{\link{stat_cdfinterval}()},
\code{\link{stat_eye}()},
\code{\link{stat_gradientinterval}()},
\code{\link{stat_halfeye}()},
\code{\link{stat_histinterval}()},
\code{\link{stat_interval}()},
\code{\link{stat_pointinterval}()},
\code{\link{stat_slab}()}
}
\concept{slabinterval stats}
